package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.PathKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * PATH-KEY Object
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping path-key-object {
 *     container path-key {
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         list path-keys {
 *             leaf loose {
 *                 type loose;
 *             }
 *             leaf pce-id {
 *                 type pce-id;
 *             }
 *             leaf path-key {
 *                 type path-key;
 *             }
 *             uses path-key-subobject;
 *         }
 *         uses object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/path-key-object</i>
 *
 */
public interface PathKeyObject
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "path-key-object").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.PathKey</code> <code>pathKey</code>, or <code>null</code> if not present
     */
    PathKey getPathKey();

}

