package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.setup.type.tlv.PathSetupType;

/**
 * PATH-SETUP-TYPE TLV
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping path-setup-type-tlv {
 *     container path-setup-type {
 *         leaf pst {
 *             type pst;
 *         }
 *         uses tlv;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/path-setup-type-tlv</i>
 *
 */
public interface PathSetupTypeTlv
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "path-setup-type-tlv").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.setup.type.tlv.PathSetupType</code> <code>pathSetupType</code>, or <code>null</code> if not present
     */
    PathSetupType getPathSetupType();

}

