package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pce.id.object.PceId;

/**
 * The PCE-ID object is used to specify a PCE's IP address.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping pce-id-object {
 *     container pce-id {
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         leaf ip-address {
 *             type ip-address;
 *         }
 *         uses object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/pce-id-object</i>
 *
 */
public interface PceIdObject
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "pce-id-object").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pce.id.object.PceId</code> <code>pceId</code>, or <code>null</code> if not present
     */
    PceId getPceId();

}

