package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime;

/**
 * The PROC-TIME object is used to report various processing timerelated metrics.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping proc-time-object {
 *     container proc-time {
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         leaf estimated {
 *             type boolean;
 *         }
 *         leaf current-proc-time {
 *             type uint32;
 *         }
 *         leaf min-proc-time {
 *             type uint32;
 *         }
 *         leaf max-proc-time {
 *             type uint32;
 *         }
 *         leaf average-proc-time {
 *             type uint32;
 *         }
 *         leaf variance-proc-time {
 *             type uint32;
 *         }
 *         uses object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/proc-time-object</i>
 *
 */
public interface ProcTimeObject
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "proc-time-object").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime</code> <code>procTime</code>, or <code>null</code> if not present
     */
    ProcTime getProcTime();

}

