package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Vendor-specific TLV.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * grouping vs-tlv {
 *     container vs-tlv {
 *         leaf enterprise-number {
 *             type enterprise-number;
 *         }
 *         choice vendor-payload {
 *         }
 *         uses tlv;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/vs-tlv</i>
 *
 */
public interface VsTlv
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "vs-tlv").intern();

    /**
     * This model is obsolete, please use vendor-information-tlvs instead
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vs.tlv.VsTlv</code> <code>vsTlv</code>, or <code>null</code> if not present
     */
    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vs.tlv.VsTlv getVsTlv();

}

