package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.xro;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.Xro;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ExcludeRouteSubobjects;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * list subobject {
 *     leaf mandatory {
 *         type mandatory;
 *     }
 *     leaf attribute {
 *         type enumeration;
 *     }
 *     choice subobject-type {
 *         case as-number-case {
 *             container as-number {
 *                 leaf as-number {
 *                     type as-number;
 *                 }
 *                 uses as-number-subobject;
 *             }
 *         }
 *         case ip-prefix-case {
 *             container ip-prefix {
 *                 leaf ip-prefix {
 *                     type ip-prefix;
 *                 }
 *                 uses ip-prefix-subobject;
 *             }
 *         }
 *         case label-case {
 *             container label {
 *                 leaf uni-directional {
 *                     type boolean;
 *                 }
 *                 choice label-type {
 *                     case generalized-label-case {
 *                         container generalized-label {
 *                             leaf generalized-label {
 *                                 type binary;
 *                             }
 *                             uses generalized-label;
 *                         }
 *                     }
 *                     case type1-label-case {
 *                         container type1-label {
 *                             leaf type1-label {
 *                                 type uint32;
 *                             }
 *                             uses type1-label;
 *                         }
 *                     }
 *                     case waveband-switching-label-case {
 *                         container waveband-switching-label {
 *                             leaf end-label {
 *                                 type uint32;
 *                             }
 *                             leaf start-label {
 *                                 type uint32;
 *                             }
 *                             leaf waveband-id {
 *                                 type uint32;
 *                             }
 *                             uses waveband-switching-label;
 *                         }
 *                     }
 *                 }
 *                 uses label-subobject;
 *             }
 *         }
 *         case srlg-case {
 *             container srlg {
 *                 leaf srlg-id {
 *                     type srlg-id;
 *                 }
 *                 uses srlg-subobject;
 *             }
 *         }
 *         case unnumbered-case {
 *             container unnumbered {
 *                 leaf router-id {
 *                     type uint32;
 *                 }
 *                 leaf interface-id {
 *                     type uint32;
 *                 }
 *                 uses unnumbered-subobject;
 *             }
 *         }
 *     }
 *     uses exclude-route-subobjects;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/exclude-route-object/xro/subobject</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.xro.SubobjectBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.xro.SubobjectBuilder
 *
 *
 */
public interface Subobject
    extends
    ChildOf<Xro>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.xro.Subobject>,
    ExcludeRouteSubobjects
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "subobject").intern();


}

