package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.gc.Tlvs;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.GcObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container gc {
 *     leaf processing-rule {
 *         type processing-rule;
 *     }
 *     leaf ignore {
 *         type ignore;
 *     }
 *     leaf max-hop {
 *         type uint8;
 *     }
 *     leaf max-utilization {
 *         type max-utilization;
 *     }
 *     leaf min-utilization {
 *         type min-utilization;
 *     }
 *     leaf over-booking-factor {
 *         type over-booking-factor;
 *     }
 *     container tlvs {
 *         list vendor-information-tlv {
 *             leaf enterprise-number {
 *                 type enterprise-number;
 *             }
 *             choice enterprise-specific-information {
 *             }
 *             uses vendor-information;
 *             uses tlv;
 *         }
 *         uses vendor-information-tlvs;
 *     }
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/gc-object/gc</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.GcBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.GcBuilder
 *
 */
public interface Gc
    extends
    ChildOf<GcObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.Gc>,
    Object
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "gc").intern();

    /**
     * @return <code>java.lang.Short</code> <code>maxHop</code>, or <code>null</code> if not present
     */
    java.lang.Short getMaxHop();
    
    /**
     * @return <code>java.lang.Short</code> <code>maxUtilization</code>, or <code>null</code> if not present
     */
    java.lang.Short getMaxUtilization();
    
    /**
     * @return <code>java.lang.Short</code> <code>minUtilization</code>, or <code>null</code> if not present
     */
    java.lang.Short getMinUtilization();
    
    /**
     * @return <code>java.lang.Short</code> <code>overBookingFactor</code>, or <code>null</code> if not present
     */
    java.lang.Short getOverBookingFactor();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.gc.object.gc.Tlvs</code> <code>tlvs</code>, or <code>null</code> if not present
     */
    Tlvs getTlvs();

}

