package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.monitoring.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MonitoringObject;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container monitoring {
 *     leaf processing-rule {
 *         type processing-rule;
 *     }
 *     leaf ignore {
 *         type ignore;
 *     }
 *     leaf flags {
 *         type bits;
 *     }
 *     leaf monitoring-id {
 *         type uint32;
 *     }
 *     container tlvs {
 *         list vendor-information-tlv {
 *             leaf enterprise-number {
 *                 type enterprise-number;
 *             }
 *             choice enterprise-specific-information {
 *             }
 *             uses vendor-information;
 *             uses tlv;
 *         }
 *         uses vendor-information-tlvs;
 *     }
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/monitoring-object/monitoring</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.MonitoringBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.MonitoringBuilder
 *
 */
public interface Monitoring
    extends
    ChildOf<MonitoringObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.Monitoring>,
    Object
{

    public static final class Flags
     {
        private final java.lang.Boolean _incomplete;
        private final java.lang.Boolean _overload;
        private final java.lang.Boolean _processingTime;
        private final java.lang.Boolean _general;
        private final java.lang.Boolean _liveness;
    
    
        public Flags(java.lang.Boolean _general, java.lang.Boolean _incomplete, java.lang.Boolean _liveness, java.lang.Boolean _overload, java.lang.Boolean _processingTime) {
        
        
            this._incomplete = _incomplete;
            this._overload = _overload;
            this._processingTime = _processingTime;
            this._general = _general;
            this._liveness = _liveness;
        }
        
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public Flags(Flags source) {
            this._incomplete = source._incomplete;
            this._overload = source._overload;
            this._processingTime = source._processingTime;
            this._general = source._general;
            this._liveness = source._liveness;
        }
    
    
        public java.lang.Boolean isIncomplete() {
            return _incomplete;
        }
        
        public java.lang.Boolean isOverload() {
            return _overload;
        }
        
        public java.lang.Boolean isProcessingTime() {
            return _processingTime;
        }
        
        public java.lang.Boolean isGeneral() {
            return _general;
        }
        
        public java.lang.Boolean isLiveness() {
            return _liveness;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_incomplete);
            result = prime * result + Objects.hashCode(_overload);
            result = prime * result + Objects.hashCode(_processingTime);
            result = prime * result + Objects.hashCode(_general);
            result = prime * result + Objects.hashCode(_liveness);
            return result;
        }
    
        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (getClass() != obj.getClass()) {
                return false;
            }
            Flags other = (Flags) obj;
            if (!Objects.equals(_incomplete, other._incomplete)) {
                return false;
            }
            if (!Objects.equals(_overload, other._overload)) {
                return false;
            }
            if (!Objects.equals(_processingTime, other._processingTime)) {
                return false;
            }
            if (!Objects.equals(_general, other._general)) {
                return false;
            }
            if (!Objects.equals(_liveness, other._liveness)) {
                return false;
            }
            return true;
        }
    
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.Monitoring.Flags.class.getSimpleName()).append(" [");
            boolean first = true;
        
            if (_incomplete != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_incomplete=");
                builder.append(_incomplete);
            }
            if (_overload != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_overload=");
                builder.append(_overload);
            }
            if (_processingTime != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_processingTime=");
                builder.append(_processingTime);
            }
            if (_general != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_general=");
                builder.append(_general);
            }
            if (_liveness != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_liveness=");
                builder.append(_liveness);
            }
            return builder.append(']').toString();
        }
    }
    
    


    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "monitoring").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.Monitoring.Flags</code> <code>flags</code>, or <code>null</code> if not present
     */
    Flags getFlags();
    
    /**
     * The Monitoring-id-number combined withthe PCC-REQ-ID identifying the requesting 
     * PCC uniquelyidentifies the monitoring request context.
     *
     *
     *
     * @return <code>java.lang.Long</code> <code>monitoringId</code>, or <code>null</code> if not present
     */
    java.lang.Long getMonitoringId();
    
    /**
     * Optional TLV(s).
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.monitoring.Tlvs</code> <code>tlvs</code>, or <code>null</code> if not present
     */
    Tlvs getTlvs();

}

