package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.response.monitoring.metrics.list;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.response.monitoring.metrics.list.specific.metrics.list.SpecificMetrics;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.response.MonitoringMetricsList;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * case specific-metrics-list {
 *     list specific-metrics {
 *         container rp {
 *             container tlvs {
 *                 container order {
 *                     leaf delete {
 *                         type uint32;
 *                     }
 *                     leaf setup {
 *                         type uint32;
 *                     }
 *                     uses tlv;
 *                 }
 *                 container path-setup-type {
 *                     leaf pst {
 *                         type pst;
 *                     }
 *                     uses tlv;
 *                 }
 *                 list vendor-information-tlv {
 *                     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses vendor-information-tlvs;
 *                 uses order-tlv;
 *                 uses path-setup-type-tlv;
 *             }
 *             leaf priority {
 *                 type uint8;
 *             }
 *             leaf request-id {
 *                 type request-id;
 *             }
 *             leaf reoptimization {
 *                 type reoptimization;
 *             }
 *             leaf bi-directional {
 *                 type bi-directional;
 *             }
 *             leaf loose {
 *                 type loose;
 *             }
 *             leaf path-key {
 *                 type path-key;
 *             }
 *             leaf fragmentation {
 *                 type fragmentation;
 *             }
 *             leaf p2mp {
 *                 type p2mp;
 *             }
 *             leaf ero-compression {
 *                 type ero-compression;
 *             }
 *             leaf supply-of {
 *                 type supply-of;
 *             }
 *             leaf order {
 *                 type order;
 *             }
 *             leaf make-before-break {
 *                 type make-before-break;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         list metric-pce {
 *             container pce-id {
 *                 leaf ip-address {
 *                     type ip-address;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container overload {
 *                 leaf duration {
 *                     type uint16;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container proc-time {
 *                 leaf estimated {
 *                     type boolean;
 *                 }
 *                 leaf current-proc-time {
 *                     type uint32;
 *                 }
 *                 leaf min-proc-time {
 *                     type uint32;
 *                 }
 *                 leaf max-proc-time {
 *                     type uint32;
 *                 }
 *                 leaf average-proc-time {
 *                     type uint32;
 *                 }
 *                 leaf variance-proc-time {
 *                     type uint32;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             uses overload-object;
 *             uses pce-id-object;
 *             uses proc-time-object;
 *         }
 *         uses rp-object;
 *         uses monitoring-metrics;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/monitoring-response/monitoring-metrics-list/specific-metrics-list</i>
 *
 */
public interface SpecificMetricsList
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.response.monitoring.metrics.list.SpecificMetricsList>,
    MonitoringMetricsList
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "specific-metrics-list").intern();

    /**
     * @return <code>java.util.List</code> <code>specificMetrics</code>, or <code>null</code> if not present
     */
    List<SpecificMetrics> getSpecificMetrics();

}

