package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open.Tlvs;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OpenObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container open {
 *     leaf processing-rule {
 *         type processing-rule;
 *     }
 *     leaf ignore {
 *         type ignore;
 *     }
 *     container tlvs {
 *         container of-list {
 *             leaf-list codes {
 *                 type of-id;
 *             }
 *             uses tlv;
 *         }
 *         list vendor-information-tlv {
 *             leaf enterprise-number {
 *                 type enterprise-number;
 *             }
 *             choice enterprise-specific-information {
 *             }
 *             uses vendor-information;
 *             uses tlv;
 *         }
 *         uses of-list-tlv;
 *         uses vendor-information-tlvs;
 *     }
 *     leaf version {
 *         type version;
 *     }
 *     leaf keepalive {
 *         type uint8;
 *     }
 *     leaf dead-timer {
 *         type uint8;
 *     }
 *     leaf session-id {
 *         type uint8;
 *     }
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/open-object/open</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.OpenBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.OpenBuilder
 *
 */
public interface Open
    extends
    ChildOf<OpenObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open>,
    Object
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "open").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open.Tlvs</code> <code>tlvs</code>, or <code>null</code> if not present
     */
    Tlvs getTlvs();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion</code> <code>version</code>, or <code>null</code> if not present
     */
    ProtocolVersion getVersion();
    
    /**
     * @return <code>java.lang.Short</code> <code>keepalive</code>, or <code>null</code> if not present
     */
    java.lang.Short getKeepalive();
    
    /**
     * @return <code>java.lang.Short</code> <code>deadTimer</code>, or <code>null</code> if not present
     */
    java.lang.Short getDeadTimer();
    
    /**
     * @return <code>java.lang.Short</code> <code>sessionId</code>, or <code>null</code> if not present
     */
    java.lang.Short getSessionId();

}

