package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.setup.type.tlv;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PathSetupTypeTlv;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container path-setup-type {
 *     leaf pst {
 *         type pst;
 *     }
 *     uses tlv;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/path-setup-type-tlv/path-setup-type</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.setup.type.tlv.PathSetupTypeBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.setup.type.tlv.PathSetupTypeBuilder
 *
 */
public interface PathSetupType
    extends
    ChildOf<PathSetupTypeTlv>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.setup.type.tlv.PathSetupType>,
    Tlv
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "path-setup-type").intern();

    /**
     * PST=0: Path is setup via RSVP-TE signaling protocol(default).
     *
     *
     *
     * @return <code>java.lang.Short</code> <code>pst</code>, or <code>null</code> if not present
     */
    java.lang.Short getPst();

}

