package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.error.object.Tlvs;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PcepErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * container error-object {
 *     leaf processing-rule {
 *         type processing-rule;
 *     }
 *     leaf ignore {
 *         type ignore;
 *     }
 *     container tlvs {
 *         container req-missing {
 *             leaf request-id {
 *                 type request-id;
 *             }
 *             uses tlv;
 *         }
 *         list vendor-information-tlv {
 *             leaf enterprise-number {
 *                 type enterprise-number;
 *             }
 *             choice enterprise-specific-information {
 *             }
 *             uses vendor-information;
 *             uses tlv;
 *         }
 *         uses vendor-information-tlvs;
 *         uses req-missing-tlv;
 *     }
 *     leaf type {
 *         type uint8;
 *     }
 *     leaf value {
 *         type uint8;
 *     }
 *     uses object;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/pcep-error-object/error-object</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObjectBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObjectBuilder
 *
 */
public interface ErrorObject
    extends
    ChildOf<PcepErrorObject>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObject>,
    Object
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "error-object").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.error.object.Tlvs</code> <code>tlvs</code>, or <code>null</code> if not present
     */
    Tlvs getTlvs();
    
    /**
     * @return <code>java.lang.Short</code> <code>type</code>, or <code>null</code> if not present
     */
    java.lang.Short getType();
    
    /**
     * @return <code>java.lang.Short</code> <code>value</code>, or <code>null</code> if not present
     */
    java.lang.Short getValue();

}

