package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.notifications.Rps;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.PcntfMessage;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * list notifications {
 *     list rps {
 *         container rp {
 *             container tlvs {
 *                 container order {
 *                     leaf delete {
 *                         type uint32;
 *                     }
 *                     leaf setup {
 *                         type uint32;
 *                     }
 *                     uses tlv;
 *                 }
 *                 container path-setup-type {
 *                     leaf pst {
 *                         type pst;
 *                     }
 *                     uses tlv;
 *                 }
 *                 list vendor-information-tlv {
 *                     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses vendor-information-tlvs;
 *                 uses order-tlv;
 *                 uses path-setup-type-tlv;
 *             }
 *             leaf priority {
 *                 type uint8;
 *             }
 *             leaf request-id {
 *                 type request-id;
 *             }
 *             leaf reoptimization {
 *                 type reoptimization;
 *             }
 *             leaf bi-directional {
 *                 type bi-directional;
 *             }
 *             leaf loose {
 *                 type loose;
 *             }
 *             leaf path-key {
 *                 type path-key;
 *             }
 *             leaf fragmentation {
 *                 type fragmentation;
 *             }
 *             leaf p2mp {
 *                 type p2mp;
 *             }
 *             leaf ero-compression {
 *                 type ero-compression;
 *             }
 *             leaf supply-of {
 *                 type supply-of;
 *             }
 *             leaf order {
 *                 type order;
 *             }
 *             leaf make-before-break {
 *                 type make-before-break;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         uses rp-object;
 *     }
 *     list notifications {
 *         container c-notification {
 *             container tlvs {
 *                 container overload-duration {
 *                     leaf duration {
 *                         type duration;
 *                     }
 *                     uses tlv;
 *                 }
 *                 list vendor-information-tlv {
 *                     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses tlv;
 *                 }
 *                 uses vendor-information-tlvs;
 *                 uses overload-duration-tlv;
 *             }
 *             leaf type {
 *                 type uint8;
 *             }
 *             leaf value {
 *                 type uint8;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         uses notification-object;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/pcntf-message/pcntf-message/notifications</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.NotificationsBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.NotificationsBuilder
 *
 *
 */
public interface Notifications
    extends
    ChildOf<PcntfMessage>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.Notifications>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "notifications").intern();

    /**
     * @return <code>java.util.List</code> <code>rps</code>, or <code>null</code> if not present
     */
    List<Rps> getRps();
    
    /**
     * @return <code>java.util.List</code> <code>notifications</code>, or <code>null</code> if not present
     */
    List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.notifications.Notifications> getNotifications();

}

