package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RpObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.PcrepMessage;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MonitoringMetrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.Result;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>pcep-types</b>
 * <pre>
 * list replies {
 *     container rp {
 *         container tlvs {
 *             container order {
 *                 leaf delete {
 *                     type uint32;
 *                 }
 *                 leaf setup {
 *                     type uint32;
 *                 }
 *                 uses tlv;
 *             }
 *             container path-setup-type {
 *                 leaf pst {
 *                     type pst;
 *                 }
 *                 uses tlv;
 *             }
 *             list vendor-information-tlv {
 *                 leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses tlv;
 *             }
 *             uses vendor-information-tlvs;
 *             uses order-tlv;
 *             uses path-setup-type-tlv;
 *         }
 *         leaf priority {
 *             type uint8;
 *         }
 *         leaf request-id {
 *             type request-id;
 *         }
 *         leaf reoptimization {
 *             type reoptimization;
 *         }
 *         leaf bi-directional {
 *             type bi-directional;
 *         }
 *         leaf loose {
 *             type loose;
 *         }
 *         leaf path-key {
 *             type path-key;
 *         }
 *         leaf fragmentation {
 *             type fragmentation;
 *         }
 *         leaf p2mp {
 *             type p2mp;
 *         }
 *         leaf ero-compression {
 *             type ero-compression;
 *         }
 *         leaf supply-of {
 *             type supply-of;
 *         }
 *         leaf order {
 *             type order;
 *         }
 *         leaf make-before-break {
 *             type make-before-break;
 *         }
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         uses object;
 *     }
 *     list vendor-information-object {
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         leaf enterprise-number {
 *             type enterprise-number;
 *         }
 *         choice enterprise-specific-information {
 *         }
 *         uses vendor-information;
 *         uses object;
 *     }
 *     container pcc-id-req {
 *         leaf ip-address {
 *             type ip-address;
 *         }
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         uses object;
 *     }
 *     container monitoring {
 *         leaf flags {
 *             type bits;
 *         }
 *         leaf monitoring-id {
 *             type uint32;
 *         }
 *         container tlvs {
 *             list vendor-information-tlv {
 *                 leaf enterprise-number {
 *                     type enterprise-number;
 *                 }
 *                 choice enterprise-specific-information {
 *                 }
 *                 uses vendor-information;
 *                 uses tlv;
 *             }
 *             uses vendor-information-tlvs;
 *         }
 *         leaf processing-rule {
 *             type processing-rule;
 *         }
 *         leaf ignore {
 *             type ignore;
 *         }
 *         uses object;
 *     }
 *     list metric-pce {
 *         container pce-id {
 *             leaf ip-address {
 *                 type ip-address;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         container overload {
 *             leaf duration {
 *                 type uint16;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         container proc-time {
 *             leaf estimated {
 *                 type boolean;
 *             }
 *             leaf current-proc-time {
 *                 type uint32;
 *             }
 *             leaf min-proc-time {
 *                 type uint32;
 *             }
 *             leaf max-proc-time {
 *                 type uint32;
 *             }
 *             leaf average-proc-time {
 *                 type uint32;
 *             }
 *             leaf variance-proc-time {
 *                 type uint32;
 *             }
 *             leaf processing-rule {
 *                 type processing-rule;
 *             }
 *             leaf ignore {
 *                 type ignore;
 *             }
 *             uses object;
 *         }
 *         uses overload-object;
 *         uses pce-id-object;
 *         uses proc-time-object;
 *     }
 *     choice result {
 *         case failure-case {
 *             container no-path {
 *                 leaf nature-of-issue {
 *                     type uint8;
 *                 }
 *                 leaf unsatisfied-constraints {
 *                     type unsatisfied-constraints;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     container no-path-vector {
 *                         leaf flags {
 *                             type bits;
 *                         }
 *                         uses no-path-vector-tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 uses no-path-object;
 *             }
 *             list metrics {
 *                 container metric {
 *                     leaf metric-type {
 *                         type uint8;
 *                     }
 *                     leaf bound {
 *                         type bound;
 *                     }
 *                     leaf computed {
 *                         type computed;
 *                     }
 *                     leaf value {
 *                         type float32;
 *                     }
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     uses object;
 *                 }
 *                 uses metric-object;
 *             }
 *             container bandwidth {
 *                 leaf bandwidth {
 *                     type bandwidth;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *                 uses bandwidth;
 *             }
 *             container reoptimization-bandwidth {
 *                 leaf bandwidth {
 *                     type bandwidth;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *                 uses bandwidth;
 *             }
 *             container class-type {
 *                 leaf class-type {
 *                     type class-type;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container lspa {
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 leaf local-protection-desired {
 *                     type local-protection-desired;
 *                 }
 *                 leaf label-recording-desired {
 *                     type label-recording-desired;
 *                 }
 *                 leaf se-style-desired {
 *                     type se-style-desired;
 *                 }
 *                 leaf session-name {
 *                     type string;
 *                 }
 *                 leaf hold-priority {
 *                     type hold-priority;
 *                 }
 *                 leaf setup-priority {
 *                     type setup-priority;
 *                 }
 *                 leaf include-any {
 *                     type attribute-filter;
 *                 }
 *                 leaf exclude-any {
 *                     type attribute-filter;
 *                 }
 *                 leaf include-all {
 *                     type attribute-filter;
 *                 }
 *                 uses tunnel-attributes;
 *                 uses object;
 *             }
 *             container of {
 *                 leaf code {
 *                     type of-id;
 *                 }
 *                 container tlvs {
 *                     list vendor-information-tlv {
 *                         leaf enterprise-number {
 *                             type enterprise-number;
 *                         }
 *                         choice enterprise-specific-information {
 *                         }
 *                         uses vendor-information;
 *                         uses tlv;
 *                     }
 *                     uses vendor-information-tlvs;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container rro {
 *                 list subobject {
 *                     leaf protection-available {
 *                         type protection-available;
 *                     }
 *                     leaf protection-in-use {
 *                         type protection-in-use;
 *                     }
 *                     choice subobject-type {
 *                         case ip-prefix-case {
 *                             container ip-prefix {
 *                                 leaf ip-prefix {
 *                                     type ip-prefix;
 *                                 }
 *                                 uses ip-prefix-subobject;
 *                             }
 *                         }
 *                         case label-case {
 *                             container label {
 *                                 leaf global {
 *                                     type global;
 *                                 }
 *                                 leaf uni-directional {
 *                                     type boolean;
 *                                 }
 *                                 choice label-type {
 *                                     case generalized-label-case {
 *                                         container generalized-label {
 *                                             leaf generalized-label {
 *                                                 type binary;
 *                                             }
 *                                             uses generalized-label;
 *                                         }
 *                                     }
 *                                     case type1-label-case {
 *                                         container type1-label {
 *                                             leaf type1-label {
 *                                                 type uint32;
 *                                             }
 *                                             uses type1-label;
 *                                         }
 *                                     }
 *                                     case waveband-switching-label-case {
 *                                         container waveband-switching-label {
 *                                             leaf end-label {
 *                                                 type uint32;
 *                                             }
 *                                             leaf start-label {
 *                                                 type uint32;
 *                                             }
 *                                             leaf waveband-id {
 *                                                 type uint32;
 *                                             }
 *                                             uses waveband-switching-label;
 *                                         }
 *                                     }
 *                                 }
 *                                 uses label-subobject;
 *                             }
 *                         }
 *                         case path-key-case {
 *                             container path-key {
 *                                 leaf pce-id {
 *                                     type pce-id;
 *                                 }
 *                                 leaf path-key {
 *                                     type path-key;
 *                                 }
 *                                 uses path-key-subobject;
 *                             }
 *                         }
 *                         case unnumbered-case {
 *                             container unnumbered {
 *                                 leaf router-id {
 *                                     type uint32;
 *                                 }
 *                                 leaf interface-id {
 *                                     type uint32;
 *                                 }
 *                                 uses unnumbered-subobject;
 *                             }
 *                         }
 *                     }
 *                     uses record-route-subobjects;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container xro {
 *                 leaf flags {
 *                     type bits;
 *                 }
 *                 list subobject {
 *                     leaf mandatory {
 *                         type mandatory;
 *                     }
 *                     leaf attribute {
 *                         type enumeration;
 *                     }
 *                     choice subobject-type {
 *                         case as-number-case {
 *                             container as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                                 uses as-number-subobject;
 *                             }
 *                         }
 *                         case ip-prefix-case {
 *                             container ip-prefix {
 *                                 leaf ip-prefix {
 *                                     type ip-prefix;
 *                                 }
 *                                 uses ip-prefix-subobject;
 *                             }
 *                         }
 *                         case label-case {
 *                             container label {
 *                                 leaf uni-directional {
 *                                     type boolean;
 *                                 }
 *                                 choice label-type {
 *                                     case generalized-label-case {
 *                                         container generalized-label {
 *                                             leaf generalized-label {
 *                                                 type binary;
 *                                             }
 *                                             uses generalized-label;
 *                                         }
 *                                     }
 *                                     case type1-label-case {
 *                                         container type1-label {
 *                                             leaf type1-label {
 *                                                 type uint32;
 *                                             }
 *                                             uses type1-label;
 *                                         }
 *                                     }
 *                                     case waveband-switching-label-case {
 *                                         container waveband-switching-label {
 *                                             leaf end-label {
 *                                                 type uint32;
 *                                             }
 *                                             leaf start-label {
 *                                                 type uint32;
 *                                             }
 *                                             leaf waveband-id {
 *                                                 type uint32;
 *                                             }
 *                                             uses waveband-switching-label;
 *                                         }
 *                                     }
 *                                 }
 *                                 uses label-subobject;
 *                             }
 *                         }
 *                         case srlg-case {
 *                             container srlg {
 *                                 leaf srlg-id {
 *                                     type srlg-id;
 *                                 }
 *                                 uses srlg-subobject;
 *                             }
 *                         }
 *                         case unnumbered-case {
 *                             container unnumbered {
 *                                 leaf router-id {
 *                                     type uint32;
 *                                 }
 *                                 leaf interface-id {
 *                                     type uint32;
 *                                 }
 *                                 uses unnumbered-subobject;
 *                             }
 *                         }
 *                     }
 *                     uses exclude-route-subobjects;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *             container iro {
 *                 list subobject {
 *                     leaf loose {
 *                         type boolean;
 *                     }
 *                     choice subobject-type {
 *                         case as-number-case {
 *                             container as-number {
 *                                 leaf as-number {
 *                                     type as-number;
 *                                 }
 *                                 uses as-number-subobject;
 *                             }
 *                         }
 *                         case exrs-case {
 *                             container exrs {
 *                                 list exrs {
 *                                     leaf mandatory {
 *                                         type mandatory;
 *                                     }
 *                                     leaf attribute {
 *                                         type enumeration;
 *                                     }
 *                                     choice subobject-type {
 *                                         case as-number-case {
 *                                             container as-number {
 *                                                 leaf as-number {
 *                                                     type as-number;
 *                                                 }
 *                                                 uses as-number-subobject;
 *                                             }
 *                                         }
 *                                         case ip-prefix-case {
 *                                             container ip-prefix {
 *                                                 leaf ip-prefix {
 *                                                     type ip-prefix;
 *                                                 }
 *                                                 uses ip-prefix-subobject;
 *                                             }
 *                                         }
 *                                         case label-case {
 *                                             container label {
 *                                                 leaf uni-directional {
 *                                                     type boolean;
 *                                                 }
 *                                                 choice label-type {
 *                                                     case generalized-label-case {
 *                                                         container generalized-label {
 *                                                             leaf generalized-label {
 *                                                                 type binary;
 *                                                             }
 *                                                             uses generalized-label;
 *                                                         }
 *                                                     }
 *                                                     case type1-label-case {
 *                                                         container type1-label {
 *                                                             leaf type1-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses type1-label;
 *                                                         }
 *                                                     }
 *                                                     case waveband-switching-label-case {
 *                                                         container waveband-switching-label {
 *                                                             leaf end-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf start-label {
 *                                                                 type uint32;
 *                                                             }
 *                                                             leaf waveband-id {
 *                                                                 type uint32;
 *                                                             }
 *                                                             uses waveband-switching-label;
 *                                                         }
 *                                                     }
 *                                                 }
 *                                                 uses label-subobject;
 *                                             }
 *                                         }
 *                                         case srlg-case {
 *                                             container srlg {
 *                                                 leaf srlg-id {
 *                                                     type srlg-id;
 *                                                 }
 *                                                 uses srlg-subobject;
 *                                             }
 *                                         }
 *                                         case unnumbered-case {
 *                                             container unnumbered {
 *                                                 leaf router-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 leaf interface-id {
 *                                                     type uint32;
 *                                                 }
 *                                                 uses unnumbered-subobject;
 *                                             }
 *                                         }
 *                                     }
 *                                     uses exclude-route-subobjects;
 *                                 }
 *                             }
 *                         }
 *                         case ip-prefix-case {
 *                             container ip-prefix {
 *                                 leaf ip-prefix {
 *                                     type ip-prefix;
 *                                 }
 *                                 uses ip-prefix-subobject;
 *                             }
 *                         }
 *                         case label-case {
 *                             container label {
 *                                 leaf uni-directional {
 *                                     type boolean;
 *                                 }
 *                                 choice label-type {
 *                                     case generalized-label-case {
 *                                         container generalized-label {
 *                                             leaf generalized-label {
 *                                                 type binary;
 *                                             }
 *                                             uses generalized-label;
 *                                         }
 *                                     }
 *                                     case type1-label-case {
 *                                         container type1-label {
 *                                             leaf type1-label {
 *                                                 type uint32;
 *                                             }
 *                                             uses type1-label;
 *                                         }
 *                                     }
 *                                     case waveband-switching-label-case {
 *                                         container waveband-switching-label {
 *                                             leaf end-label {
 *                                                 type uint32;
 *                                             }
 *                                             leaf start-label {
 *                                                 type uint32;
 *                                             }
 *                                             leaf waveband-id {
 *                                                 type uint32;
 *                                             }
 *                                             uses waveband-switching-label;
 *                                         }
 *                                     }
 *                                 }
 *                                 uses label-subobject;
 *                             }
 *                         }
 *                         case path-key-case {
 *                             container path-key {
 *                                 leaf pce-id {
 *                                     type pce-id;
 *                                 }
 *                                 leaf path-key {
 *                                     type path-key;
 *                                 }
 *                                 uses path-key-subobject;
 *                             }
 *                         }
 *                         case srlg-case {
 *                             container srlg {
 *                                 leaf srlg-id {
 *                                     type srlg-id;
 *                                 }
 *                                 uses srlg-subobject;
 *                             }
 *                         }
 *                         case unnumbered-case {
 *                             container unnumbered {
 *                                 leaf router-id {
 *                                     type uint32;
 *                                 }
 *                                 leaf interface-id {
 *                                     type uint32;
 *                                 }
 *                                 uses unnumbered-subobject;
 *                             }
 *                         }
 *                     }
 *                     uses explicit-route-subobjects;
 *                 }
 *                 leaf processing-rule {
 *                     type processing-rule;
 *                 }
 *                 leaf ignore {
 *                     type ignore;
 *                 }
 *                 uses object;
 *             }
 *         }
 *         case success-case {
 *             container success {
 *                 list paths {
 *                     container ero {
 *                         list subobject {
 *                             leaf loose {
 *                                 type boolean;
 *                             }
 *                             choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case exrs-case {
 *                                     container exrs {
 *                                         list exrs {
 *                                             leaf mandatory {
 *                                                 type mandatory;
 *                                             }
 *                                             leaf attribute {
 *                                                 type enumeration;
 *                                             }
 *                                             choice subobject-type {
 *                                                 case as-number-case {
 *                                                     container as-number {
 *                                                         leaf as-number {
 *                                                             type as-number;
 *                                                         }
 *                                                         uses as-number-subobject;
 *                                                     }
 *                                                 }
 *                                                 case ip-prefix-case {
 *                                                     container ip-prefix {
 *                                                         leaf ip-prefix {
 *                                                             type ip-prefix;
 *                                                         }
 *                                                         uses ip-prefix-subobject;
 *                                                     }
 *                                                 }
 *                                                 case label-case {
 *                                                     container label {
 *                                                         leaf uni-directional {
 *                                                             type boolean;
 *                                                         }
 *                                                         choice label-type {
 *                                                             case generalized-label-case {
 *                                                                 container generalized-label {
 *                                                                     leaf generalized-label {
 *                                                                         type binary;
 *                                                                     }
 *                                                                     uses generalized-label;
 *                                                                 }
 *                                                             }
 *                                                             case type1-label-case {
 *                                                                 container type1-label {
 *                                                                     leaf type1-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses type1-label;
 *                                                                 }
 *                                                             }
 *                                                             case waveband-switching-label-case {
 *                                                                 container waveband-switching-label {
 *                                                                     leaf end-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf start-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf waveband-id {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses waveband-switching-label;
 *                                                                 }
 *                                                             }
 *                                                         }
 *                                                         uses label-subobject;
 *                                                     }
 *                                                 }
 *                                                 case srlg-case {
 *                                                     container srlg {
 *                                                         leaf srlg-id {
 *                                                             type srlg-id;
 *                                                         }
 *                                                         uses srlg-subobject;
 *                                                     }
 *                                                 }
 *                                                 case unnumbered-case {
 *                                                     container unnumbered {
 *                                                         leaf router-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf interface-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses unnumbered-subobject;
 *                                                     }
 *                                                 }
 *                                             }
 *                                             uses exclude-route-subobjects;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case path-key-case {
 *                                     container path-key {
 *                                         leaf pce-id {
 *                                             type pce-id;
 *                                         }
 *                                         leaf path-key {
 *                                             type path-key;
 *                                         }
 *                                         uses path-key-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses explicit-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     list metrics {
 *                         container metric {
 *                             leaf metric-type {
 *                                 type uint8;
 *                             }
 *                             leaf bound {
 *                                 type bound;
 *                             }
 *                             leaf computed {
 *                                 type computed;
 *                             }
 *                             leaf value {
 *                                 type float32;
 *                             }
 *                             leaf processing-rule {
 *                                 type processing-rule;
 *                             }
 *                             leaf ignore {
 *                                 type ignore;
 *                             }
 *                             uses object;
 *                         }
 *                         uses metric-object;
 *                     }
 *                     container bandwidth {
 *                         leaf bandwidth {
 *                             type bandwidth;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                         uses bandwidth;
 *                     }
 *                     container reoptimization-bandwidth {
 *                         leaf bandwidth {
 *                             type bandwidth;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                         uses bandwidth;
 *                     }
 *                     container class-type {
 *                         leaf class-type {
 *                             type class-type;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container lspa {
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         leaf local-protection-desired {
 *                             type local-protection-desired;
 *                         }
 *                         leaf label-recording-desired {
 *                             type label-recording-desired;
 *                         }
 *                         leaf se-style-desired {
 *                             type se-style-desired;
 *                         }
 *                         leaf session-name {
 *                             type string;
 *                         }
 *                         leaf hold-priority {
 *                             type hold-priority;
 *                         }
 *                         leaf setup-priority {
 *                             type setup-priority;
 *                         }
 *                         leaf include-any {
 *                             type attribute-filter;
 *                         }
 *                         leaf exclude-any {
 *                             type attribute-filter;
 *                         }
 *                         leaf include-all {
 *                             type attribute-filter;
 *                         }
 *                         uses tunnel-attributes;
 *                         uses object;
 *                     }
 *                     container of {
 *                         leaf code {
 *                             type of-id;
 *                         }
 *                         container tlvs {
 *                             list vendor-information-tlv {
 *                                 leaf enterprise-number {
 *                                     type enterprise-number;
 *                                 }
 *                                 choice enterprise-specific-information {
 *                                 }
 *                                 uses vendor-information;
 *                                 uses tlv;
 *                             }
 *                             uses vendor-information-tlvs;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container rro {
 *                         list subobject {
 *                             leaf protection-available {
 *                                 type protection-available;
 *                             }
 *                             leaf protection-in-use {
 *                                 type protection-in-use;
 *                             }
 *                             choice subobject-type {
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf global {
 *                                             type global;
 *                                         }
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case path-key-case {
 *                                     container path-key {
 *                                         leaf pce-id {
 *                                             type pce-id;
 *                                         }
 *                                         leaf path-key {
 *                                             type path-key;
 *                                         }
 *                                         uses path-key-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses record-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container xro {
 *                         leaf flags {
 *                             type bits;
 *                         }
 *                         list subobject {
 *                             leaf mandatory {
 *                                 type mandatory;
 *                             }
 *                             leaf attribute {
 *                                 type enumeration;
 *                             }
 *                             choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses exclude-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     container iro {
 *                         list subobject {
 *                             leaf loose {
 *                                 type boolean;
 *                             }
 *                             choice subobject-type {
 *                                 case as-number-case {
 *                                     container as-number {
 *                                         leaf as-number {
 *                                             type as-number;
 *                                         }
 *                                         uses as-number-subobject;
 *                                     }
 *                                 }
 *                                 case exrs-case {
 *                                     container exrs {
 *                                         list exrs {
 *                                             leaf mandatory {
 *                                                 type mandatory;
 *                                             }
 *                                             leaf attribute {
 *                                                 type enumeration;
 *                                             }
 *                                             choice subobject-type {
 *                                                 case as-number-case {
 *                                                     container as-number {
 *                                                         leaf as-number {
 *                                                             type as-number;
 *                                                         }
 *                                                         uses as-number-subobject;
 *                                                     }
 *                                                 }
 *                                                 case ip-prefix-case {
 *                                                     container ip-prefix {
 *                                                         leaf ip-prefix {
 *                                                             type ip-prefix;
 *                                                         }
 *                                                         uses ip-prefix-subobject;
 *                                                     }
 *                                                 }
 *                                                 case label-case {
 *                                                     container label {
 *                                                         leaf uni-directional {
 *                                                             type boolean;
 *                                                         }
 *                                                         choice label-type {
 *                                                             case generalized-label-case {
 *                                                                 container generalized-label {
 *                                                                     leaf generalized-label {
 *                                                                         type binary;
 *                                                                     }
 *                                                                     uses generalized-label;
 *                                                                 }
 *                                                             }
 *                                                             case type1-label-case {
 *                                                                 container type1-label {
 *                                                                     leaf type1-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses type1-label;
 *                                                                 }
 *                                                             }
 *                                                             case waveband-switching-label-case {
 *                                                                 container waveband-switching-label {
 *                                                                     leaf end-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf start-label {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     leaf waveband-id {
 *                                                                         type uint32;
 *                                                                     }
 *                                                                     uses waveband-switching-label;
 *                                                                 }
 *                                                             }
 *                                                         }
 *                                                         uses label-subobject;
 *                                                     }
 *                                                 }
 *                                                 case srlg-case {
 *                                                     container srlg {
 *                                                         leaf srlg-id {
 *                                                             type srlg-id;
 *                                                         }
 *                                                         uses srlg-subobject;
 *                                                     }
 *                                                 }
 *                                                 case unnumbered-case {
 *                                                     container unnumbered {
 *                                                         leaf router-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         leaf interface-id {
 *                                                             type uint32;
 *                                                         }
 *                                                         uses unnumbered-subobject;
 *                                                     }
 *                                                 }
 *                                             }
 *                                             uses exclude-route-subobjects;
 *                                         }
 *                                     }
 *                                 }
 *                                 case ip-prefix-case {
 *                                     container ip-prefix {
 *                                         leaf ip-prefix {
 *                                             type ip-prefix;
 *                                         }
 *                                         uses ip-prefix-subobject;
 *                                     }
 *                                 }
 *                                 case label-case {
 *                                     container label {
 *                                         leaf uni-directional {
 *                                             type boolean;
 *                                         }
 *                                         choice label-type {
 *                                             case generalized-label-case {
 *                                                 container generalized-label {
 *                                                     leaf generalized-label {
 *                                                         type binary;
 *                                                     }
 *                                                     uses generalized-label;
 *                                                 }
 *                                             }
 *                                             case type1-label-case {
 *                                                 container type1-label {
 *                                                     leaf type1-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses type1-label;
 *                                                 }
 *                                             }
 *                                             case waveband-switching-label-case {
 *                                                 container waveband-switching-label {
 *                                                     leaf end-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf start-label {
 *                                                         type uint32;
 *                                                     }
 *                                                     leaf waveband-id {
 *                                                         type uint32;
 *                                                     }
 *                                                     uses waveband-switching-label;
 *                                                 }
 *                                             }
 *                                         }
 *                                         uses label-subobject;
 *                                     }
 *                                 }
 *                                 case path-key-case {
 *                                     container path-key {
 *                                         leaf pce-id {
 *                                             type pce-id;
 *                                         }
 *                                         leaf path-key {
 *                                             type path-key;
 *                                         }
 *                                         uses path-key-subobject;
 *                                     }
 *                                 }
 *                                 case srlg-case {
 *                                     container srlg {
 *                                         leaf srlg-id {
 *                                             type srlg-id;
 *                                         }
 *                                         uses srlg-subobject;
 *                                     }
 *                                 }
 *                                 case unnumbered-case {
 *                                     container unnumbered {
 *                                         leaf router-id {
 *                                             type uint32;
 *                                         }
 *                                         leaf interface-id {
 *                                             type uint32;
 *                                         }
 *                                         uses unnumbered-subobject;
 *                                     }
 *                                 }
 *                             }
 *                             uses explicit-route-subobjects;
 *                         }
 *                         leaf processing-rule {
 *                             type processing-rule;
 *                         }
 *                         leaf ignore {
 *                             type ignore;
 *                         }
 *                         uses object;
 *                     }
 *                     uses path-definition;
 *                 }
 *                 list vendor-information-object {
 *                     leaf processing-rule {
 *                         type processing-rule;
 *                     }
 *                     leaf ignore {
 *                         type ignore;
 *                     }
 *                     leaf enterprise-number {
 *                         type enterprise-number;
 *                     }
 *                     choice enterprise-specific-information {
 *                     }
 *                     uses vendor-information;
 *                     uses object;
 *                 }
 *                 uses vendor-information-objects;
 *             }
 *         }
 *     }
 *     uses rp-object;
 *     uses vendor-information-objects;
 *     uses monitoring-metrics;
 *     uses monitoring;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>pcep-types/pcrep-message/pcrep-message/replies</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.RepliesBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.RepliesBuilder
 *
 *
 */
public interface Replies
    extends
    ChildOf<PcrepMessage>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.Replies>,
    RpObject,
    VendorInformationObjects,
    MonitoringMetrics,
    Monitoring
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:types",
        "2013-10-05", "replies").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.Result</code> <code>result</code>, or <code>null</code> if not present
     */
    Result getResult();

}

