package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime
 *
 */
public class ProcTimeBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime> {

    private java.lang.Long _averageProcTime;
    private java.lang.Long _currentProcTime;
    private java.lang.Long _maxProcTime;
    private java.lang.Long _minProcTime;
    private java.lang.Long _varianceProcTime;
    private java.lang.Boolean _estimated;
    private java.lang.Boolean _ignore;
    private java.lang.Boolean _processingRule;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>> augmentation = Collections.emptyMap();

    public ProcTimeBuilder() {
    }
    public ProcTimeBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public ProcTimeBuilder(ProcTime base) {
        this._averageProcTime = base.getAverageProcTime();
        this._currentProcTime = base.getCurrentProcTime();
        this._maxProcTime = base.getMaxProcTime();
        this._minProcTime = base.getMinProcTime();
        this._varianceProcTime = base.getVarianceProcTime();
        this._estimated = base.isEstimated();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof ProcTimeImpl) {
            ProcTimeImpl impl = (ProcTimeImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader) {
            this._processingRule = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader)arg).isProcessingRule();
            this._ignore = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \n" +
              "but was: " + arg
            );
        }
    }

    public java.lang.Long getAverageProcTime() {
        return _averageProcTime;
    }
    
    public java.lang.Long getCurrentProcTime() {
        return _currentProcTime;
    }
    
    public java.lang.Long getMaxProcTime() {
        return _maxProcTime;
    }
    
    public java.lang.Long getMinProcTime() {
        return _minProcTime;
    }
    
    public java.lang.Long getVarianceProcTime() {
        return _varianceProcTime;
    }
    
    public java.lang.Boolean isEstimated() {
        return _estimated;
    }
    
    public java.lang.Boolean isIgnore() {
        return _ignore;
    }
    
    public java.lang.Boolean isProcessingRule() {
        return _processingRule;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
     private static void checkAverageProcTimeRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
     }
    
    public ProcTimeBuilder setAverageProcTime(final java.lang.Long value) {
    if (value != null) {
        checkAverageProcTimeRange(value);
    }
        this._averageProcTime = value;
        return this;
    }
    
     
     private static void checkCurrentProcTimeRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
     }
    
    public ProcTimeBuilder setCurrentProcTime(final java.lang.Long value) {
    if (value != null) {
        checkCurrentProcTimeRange(value);
    }
        this._currentProcTime = value;
        return this;
    }
    
     
     private static void checkMaxProcTimeRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
     }
    
    public ProcTimeBuilder setMaxProcTime(final java.lang.Long value) {
    if (value != null) {
        checkMaxProcTimeRange(value);
    }
        this._maxProcTime = value;
        return this;
    }
    
     
     private static void checkMinProcTimeRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
     }
    
    public ProcTimeBuilder setMinProcTime(final java.lang.Long value) {
    if (value != null) {
        checkMinProcTimeRange(value);
    }
        this._minProcTime = value;
        return this;
    }
    
     
     private static void checkVarianceProcTimeRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
     }
    
    public ProcTimeBuilder setVarianceProcTime(final java.lang.Long value) {
    if (value != null) {
        checkVarianceProcTimeRange(value);
    }
        this._varianceProcTime = value;
        return this;
    }
    
     
    public ProcTimeBuilder setEstimated(final java.lang.Boolean value) {
        this._estimated = value;
        return this;
    }
    
     
    public ProcTimeBuilder setIgnore(final java.lang.Boolean value) {
        this._ignore = value;
        return this;
    }
    
     
    public ProcTimeBuilder setProcessingRule(final java.lang.Boolean value) {
        this._processingRule = value;
        return this;
    }
    
    public ProcTimeBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ProcTimeBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ProcTime build() {
        return new ProcTimeImpl(this);
    }

    private static final class ProcTimeImpl implements ProcTime {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime.class;
        }

        private final java.lang.Long _averageProcTime;
        private final java.lang.Long _currentProcTime;
        private final java.lang.Long _maxProcTime;
        private final java.lang.Long _minProcTime;
        private final java.lang.Long _varianceProcTime;
        private final java.lang.Boolean _estimated;
        private final java.lang.Boolean _ignore;
        private final java.lang.Boolean _processingRule;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>> augmentation = Collections.emptyMap();

        private ProcTimeImpl(ProcTimeBuilder base) {
            this._averageProcTime = base.getAverageProcTime();
            this._currentProcTime = base.getCurrentProcTime();
            this._maxProcTime = base.getMaxProcTime();
            this._minProcTime = base.getMinProcTime();
            this._varianceProcTime = base.getVarianceProcTime();
            this._estimated = base.isEstimated();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.Long getAverageProcTime() {
            return _averageProcTime;
        }
        
        @Override
        public java.lang.Long getCurrentProcTime() {
            return _currentProcTime;
        }
        
        @Override
        public java.lang.Long getMaxProcTime() {
            return _maxProcTime;
        }
        
        @Override
        public java.lang.Long getMinProcTime() {
            return _minProcTime;
        }
        
        @Override
        public java.lang.Long getVarianceProcTime() {
            return _varianceProcTime;
        }
        
        @Override
        public java.lang.Boolean isEstimated() {
            return _estimated;
        }
        
        @Override
        public java.lang.Boolean isIgnore() {
            return _ignore;
        }
        
        @Override
        public java.lang.Boolean isProcessingRule() {
            return _processingRule;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_averageProcTime);
            result = prime * result + Objects.hashCode(_currentProcTime);
            result = prime * result + Objects.hashCode(_maxProcTime);
            result = prime * result + Objects.hashCode(_minProcTime);
            result = prime * result + Objects.hashCode(_varianceProcTime);
            result = prime * result + Objects.hashCode(_estimated);
            result = prime * result + Objects.hashCode(_ignore);
            result = prime * result + Objects.hashCode(_processingRule);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime)obj;
            if (!Objects.equals(_averageProcTime, other.getAverageProcTime())) {
                return false;
            }
            if (!Objects.equals(_currentProcTime, other.getCurrentProcTime())) {
                return false;
            }
            if (!Objects.equals(_maxProcTime, other.getMaxProcTime())) {
                return false;
            }
            if (!Objects.equals(_minProcTime, other.getMinProcTime())) {
                return false;
            }
            if (!Objects.equals(_varianceProcTime, other.getVarianceProcTime())) {
                return false;
            }
            if (!Objects.equals(_estimated, other.isEstimated())) {
                return false;
            }
            if (!Objects.equals(_ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(_processingRule, other.isProcessingRule())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ProcTimeImpl otherImpl = (ProcTimeImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "ProcTime [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_averageProcTime != null) {
                builder.append("_averageProcTime=");
                builder.append(_averageProcTime);
                builder.append(", ");
            }
            if (_currentProcTime != null) {
                builder.append("_currentProcTime=");
                builder.append(_currentProcTime);
                builder.append(", ");
            }
            if (_maxProcTime != null) {
                builder.append("_maxProcTime=");
                builder.append(_maxProcTime);
                builder.append(", ");
            }
            if (_minProcTime != null) {
                builder.append("_minProcTime=");
                builder.append(_minProcTime);
                builder.append(", ");
            }
            if (_varianceProcTime != null) {
                builder.append("_varianceProcTime=");
                builder.append(_varianceProcTime);
                builder.append(", ");
            }
            if (_estimated != null) {
                builder.append("_estimated=");
                builder.append(_estimated);
                builder.append(", ");
            }
            if (_ignore != null) {
                builder.append("_ignore=");
                builder.append(_ignore);
                builder.append(", ");
            }
            if (_processingRule != null) {
                builder.append("_processingRule=");
                builder.append(_processingRule);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
