package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.rp.Tlvs;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RequestId;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp
 *
 */
public class RpBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp> {

    private java.lang.Short _priority;
    private RequestId _requestId;
    private Tlvs _tlvs;
    private java.lang.Boolean _biDirectional;
    private java.lang.Boolean _eroCompression;
    private java.lang.Boolean _fragmentation;
    private java.lang.Boolean _ignore;
    private java.lang.Boolean _loose;
    private java.lang.Boolean _makeBeforeBreak;
    private java.lang.Boolean _order;
    private java.lang.Boolean _p2mp;
    private java.lang.Boolean _pathKey;
    private java.lang.Boolean _processingRule;
    private java.lang.Boolean _reoptimization;
    private java.lang.Boolean _supplyOf;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> augmentation = Collections.emptyMap();

    public RpBuilder() {
    }
    public RpBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public RpBuilder(Rp base) {
        this._priority = base.getPriority();
        this._requestId = base.getRequestId();
        this._tlvs = base.getTlvs();
        this._biDirectional = base.isBiDirectional();
        this._eroCompression = base.isEroCompression();
        this._fragmentation = base.isFragmentation();
        this._ignore = base.isIgnore();
        this._loose = base.isLoose();
        this._makeBeforeBreak = base.isMakeBeforeBreak();
        this._order = base.isOrder();
        this._p2mp = base.isP2mp();
        this._pathKey = base.isPathKey();
        this._processingRule = base.isProcessingRule();
        this._reoptimization = base.isReoptimization();
        this._supplyOf = base.isSupplyOf();
        if (base instanceof RpImpl) {
            RpImpl impl = (RpImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader) {
            this._processingRule = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader)arg).isProcessingRule();
            this._ignore = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \n" +
              "but was: " + arg
            );
        }
    }

    public java.lang.Short getPriority() {
        return _priority;
    }
    
    public RequestId getRequestId() {
        return _requestId;
    }
    
    public Tlvs getTlvs() {
        return _tlvs;
    }
    
    public java.lang.Boolean isBiDirectional() {
        return _biDirectional;
    }
    
    public java.lang.Boolean isEroCompression() {
        return _eroCompression;
    }
    
    public java.lang.Boolean isFragmentation() {
        return _fragmentation;
    }
    
    public java.lang.Boolean isIgnore() {
        return _ignore;
    }
    
    public java.lang.Boolean isLoose() {
        return _loose;
    }
    
    public java.lang.Boolean isMakeBeforeBreak() {
        return _makeBeforeBreak;
    }
    
    public java.lang.Boolean isOrder() {
        return _order;
    }
    
    public java.lang.Boolean isP2mp() {
        return _p2mp;
    }
    
    public java.lang.Boolean isPathKey() {
        return _pathKey;
    }
    
    public java.lang.Boolean isProcessingRule() {
        return _processingRule;
    }
    
    public java.lang.Boolean isReoptimization() {
        return _reoptimization;
    }
    
    public java.lang.Boolean isSupplyOf() {
        return _supplyOf;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
     private static void checkPriorityRange(final short value) {
         if (value >= (short)1 && value <= (short)7) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1..7]].", value));
     }
    
    public RpBuilder setPriority(final java.lang.Short value) {
    if (value != null) {
        checkPriorityRange(value);
    }
        this._priority = value;
        return this;
    }
    
     
    public RpBuilder setRequestId(final RequestId value) {
        this._requestId = value;
        return this;
    }
    
     
    public RpBuilder setTlvs(final Tlvs value) {
        this._tlvs = value;
        return this;
    }
    
     
    public RpBuilder setBiDirectional(final java.lang.Boolean value) {
        this._biDirectional = value;
        return this;
    }
    
     
    public RpBuilder setEroCompression(final java.lang.Boolean value) {
        this._eroCompression = value;
        return this;
    }
    
     
    public RpBuilder setFragmentation(final java.lang.Boolean value) {
        this._fragmentation = value;
        return this;
    }
    
     
    public RpBuilder setIgnore(final java.lang.Boolean value) {
        this._ignore = value;
        return this;
    }
    
     
    public RpBuilder setLoose(final java.lang.Boolean value) {
        this._loose = value;
        return this;
    }
    
     
    public RpBuilder setMakeBeforeBreak(final java.lang.Boolean value) {
        this._makeBeforeBreak = value;
        return this;
    }
    
     
    public RpBuilder setOrder(final java.lang.Boolean value) {
        this._order = value;
        return this;
    }
    
     
    public RpBuilder setP2mp(final java.lang.Boolean value) {
        this._p2mp = value;
        return this;
    }
    
     
    public RpBuilder setPathKey(final java.lang.Boolean value) {
        this._pathKey = value;
        return this;
    }
    
     
    public RpBuilder setProcessingRule(final java.lang.Boolean value) {
        this._processingRule = value;
        return this;
    }
    
     
    public RpBuilder setReoptimization(final java.lang.Boolean value) {
        this._reoptimization = value;
        return this;
    }
    
     
    public RpBuilder setSupplyOf(final java.lang.Boolean value) {
        this._supplyOf = value;
        return this;
    }
    
    public RpBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public RpBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Rp build() {
        return new RpImpl(this);
    }

    private static final class RpImpl implements Rp {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp.class;
        }

        private final java.lang.Short _priority;
        private final RequestId _requestId;
        private final Tlvs _tlvs;
        private final java.lang.Boolean _biDirectional;
        private final java.lang.Boolean _eroCompression;
        private final java.lang.Boolean _fragmentation;
        private final java.lang.Boolean _ignore;
        private final java.lang.Boolean _loose;
        private final java.lang.Boolean _makeBeforeBreak;
        private final java.lang.Boolean _order;
        private final java.lang.Boolean _p2mp;
        private final java.lang.Boolean _pathKey;
        private final java.lang.Boolean _processingRule;
        private final java.lang.Boolean _reoptimization;
        private final java.lang.Boolean _supplyOf;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> augmentation = Collections.emptyMap();

        private RpImpl(RpBuilder base) {
            this._priority = base.getPriority();
            this._requestId = base.getRequestId();
            this._tlvs = base.getTlvs();
            this._biDirectional = base.isBiDirectional();
            this._eroCompression = base.isEroCompression();
            this._fragmentation = base.isFragmentation();
            this._ignore = base.isIgnore();
            this._loose = base.isLoose();
            this._makeBeforeBreak = base.isMakeBeforeBreak();
            this._order = base.isOrder();
            this._p2mp = base.isP2mp();
            this._pathKey = base.isPathKey();
            this._processingRule = base.isProcessingRule();
            this._reoptimization = base.isReoptimization();
            this._supplyOf = base.isSupplyOf();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.Short getPriority() {
            return _priority;
        }
        
        @Override
        public RequestId getRequestId() {
            return _requestId;
        }
        
        @Override
        public Tlvs getTlvs() {
            return _tlvs;
        }
        
        @Override
        public java.lang.Boolean isBiDirectional() {
            return _biDirectional;
        }
        
        @Override
        public java.lang.Boolean isEroCompression() {
            return _eroCompression;
        }
        
        @Override
        public java.lang.Boolean isFragmentation() {
            return _fragmentation;
        }
        
        @Override
        public java.lang.Boolean isIgnore() {
            return _ignore;
        }
        
        @Override
        public java.lang.Boolean isLoose() {
            return _loose;
        }
        
        @Override
        public java.lang.Boolean isMakeBeforeBreak() {
            return _makeBeforeBreak;
        }
        
        @Override
        public java.lang.Boolean isOrder() {
            return _order;
        }
        
        @Override
        public java.lang.Boolean isP2mp() {
            return _p2mp;
        }
        
        @Override
        public java.lang.Boolean isPathKey() {
            return _pathKey;
        }
        
        @Override
        public java.lang.Boolean isProcessingRule() {
            return _processingRule;
        }
        
        @Override
        public java.lang.Boolean isReoptimization() {
            return _reoptimization;
        }
        
        @Override
        public java.lang.Boolean isSupplyOf() {
            return _supplyOf;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_priority);
            result = prime * result + Objects.hashCode(_requestId);
            result = prime * result + Objects.hashCode(_tlvs);
            result = prime * result + Objects.hashCode(_biDirectional);
            result = prime * result + Objects.hashCode(_eroCompression);
            result = prime * result + Objects.hashCode(_fragmentation);
            result = prime * result + Objects.hashCode(_ignore);
            result = prime * result + Objects.hashCode(_loose);
            result = prime * result + Objects.hashCode(_makeBeforeBreak);
            result = prime * result + Objects.hashCode(_order);
            result = prime * result + Objects.hashCode(_p2mp);
            result = prime * result + Objects.hashCode(_pathKey);
            result = prime * result + Objects.hashCode(_processingRule);
            result = prime * result + Objects.hashCode(_reoptimization);
            result = prime * result + Objects.hashCode(_supplyOf);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp)obj;
            if (!Objects.equals(_priority, other.getPriority())) {
                return false;
            }
            if (!Objects.equals(_requestId, other.getRequestId())) {
                return false;
            }
            if (!Objects.equals(_tlvs, other.getTlvs())) {
                return false;
            }
            if (!Objects.equals(_biDirectional, other.isBiDirectional())) {
                return false;
            }
            if (!Objects.equals(_eroCompression, other.isEroCompression())) {
                return false;
            }
            if (!Objects.equals(_fragmentation, other.isFragmentation())) {
                return false;
            }
            if (!Objects.equals(_ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(_loose, other.isLoose())) {
                return false;
            }
            if (!Objects.equals(_makeBeforeBreak, other.isMakeBeforeBreak())) {
                return false;
            }
            if (!Objects.equals(_order, other.isOrder())) {
                return false;
            }
            if (!Objects.equals(_p2mp, other.isP2mp())) {
                return false;
            }
            if (!Objects.equals(_pathKey, other.isPathKey())) {
                return false;
            }
            if (!Objects.equals(_processingRule, other.isProcessingRule())) {
                return false;
            }
            if (!Objects.equals(_reoptimization, other.isReoptimization())) {
                return false;
            }
            if (!Objects.equals(_supplyOf, other.isSupplyOf())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                RpImpl otherImpl = (RpImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "Rp [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_priority != null) {
                builder.append("_priority=");
                builder.append(_priority);
                builder.append(", ");
            }
            if (_requestId != null) {
                builder.append("_requestId=");
                builder.append(_requestId);
                builder.append(", ");
            }
            if (_tlvs != null) {
                builder.append("_tlvs=");
                builder.append(_tlvs);
                builder.append(", ");
            }
            if (_biDirectional != null) {
                builder.append("_biDirectional=");
                builder.append(_biDirectional);
                builder.append(", ");
            }
            if (_eroCompression != null) {
                builder.append("_eroCompression=");
                builder.append(_eroCompression);
                builder.append(", ");
            }
            if (_fragmentation != null) {
                builder.append("_fragmentation=");
                builder.append(_fragmentation);
                builder.append(", ");
            }
            if (_ignore != null) {
                builder.append("_ignore=");
                builder.append(_ignore);
                builder.append(", ");
            }
            if (_loose != null) {
                builder.append("_loose=");
                builder.append(_loose);
                builder.append(", ");
            }
            if (_makeBeforeBreak != null) {
                builder.append("_makeBeforeBreak=");
                builder.append(_makeBeforeBreak);
                builder.append(", ");
            }
            if (_order != null) {
                builder.append("_order=");
                builder.append(_order);
                builder.append(", ");
            }
            if (_p2mp != null) {
                builder.append("_p2mp=");
                builder.append(_p2mp);
                builder.append(", ");
            }
            if (_pathKey != null) {
                builder.append("_pathKey=");
                builder.append(_pathKey);
                builder.append(", ");
            }
            if (_processingRule != null) {
                builder.append("_processingRule=");
                builder.append(_processingRule);
                builder.append(", ");
            }
            if (_reoptimization != null) {
                builder.append("_reoptimization=");
                builder.append(_reoptimization);
                builder.append(", ");
            }
            if (_supplyOf != null) {
                builder.append("_supplyOf=");
                builder.append(_supplyOf);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
