/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep;

import com.google.common.base.Verify;
import java.util.Arrays;

public enum TerminationReason {
    UNKNOWN(1),
    EXP_DEADTIMER(2),
    MALFORMED_MSG(3),
    TOO_MANY_UNKNWN_REQS(4),
    TOO_MANY_UNKNOWN_MSGS(5);

    private static final TerminationReason[] REASONS;
    private short value;

    private TerminationReason(int value) {
        this.value = (short)value;
    }

    public short getShortValue() {
        return this.value;
    }

    public static TerminationReason forValue(short valueArg) {
        return valueArg < 0 || valueArg >= REASONS.length ? null : REASONS[valueArg];
    }

    static {
        TerminationReason[] reasons = TerminationReason.values();
        Verify.verify((reasons.length > 0 ? 1 : 0) != 0);
        short highest = Arrays.stream(reasons).map(TerminationReason::getShortValue).max(Short::compareTo).get();
        TerminationReason[] init = new TerminationReason[highest + 1];
        TerminationReason[] terminationReasonArray = reasons;
        int n = terminationReasonArray.length;
        for (int i = 0; i < n; ++i) {
            TerminationReason reason;
            init[reason.getShortValue()] = reason = terminationReasonArray[i];
        }
        REASONS = init;
    }
}

