/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.ErrorMessagesGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.ReplyTimeGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.ErrorMessages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.Messages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping.ReplyTime;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MessagesBuilder
implements Builder<Messages> {
    private ErrorMessages _errorMessages;
    private Long _lastSentMsgTimestamp;
    private Long _receivedMsgCount;
    private ReplyTime _replyTime;
    private Long _sentMsgCount;
    private Integer _unknownMsgReceived;
    Map<Class<? extends Augmentation<Messages>>, Augmentation<Messages>> augmentation = Collections.emptyMap();

    public MessagesBuilder() {
    }

    public MessagesBuilder(ReplyTimeGrouping arg) {
        this._replyTime = arg.getReplyTime();
    }

    public MessagesBuilder(ErrorMessagesGrouping arg) {
        this._errorMessages = arg.getErrorMessages();
    }

    public MessagesBuilder(Messages base) {
        AugmentationHolder casted;
        this._errorMessages = base.getErrorMessages();
        this._lastSentMsgTimestamp = base.getLastSentMsgTimestamp();
        this._receivedMsgCount = base.getReceivedMsgCount();
        this._replyTime = base.getReplyTime();
        this._sentMsgCount = base.getSentMsgCount();
        this._unknownMsgReceived = base.getUnknownMsgReceived();
        if (base instanceof MessagesImpl) {
            MessagesImpl impl = (MessagesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Messages>>, Augmentation<Messages>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Messages>>, Augmentation<Messages>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ReplyTimeGrouping) {
            this._replyTime = ((ReplyTimeGrouping)arg).getReplyTime();
            isValidArg = true;
        }
        if (arg instanceof ErrorMessagesGrouping) {
            this._errorMessages = ((ErrorMessagesGrouping)arg).getErrorMessages();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.ReplyTimeGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.ErrorMessagesGrouping] \nbut was: " + arg);
        }
    }

    public ErrorMessages getErrorMessages() {
        return this._errorMessages;
    }

    public Long getLastSentMsgTimestamp() {
        return this._lastSentMsgTimestamp;
    }

    public Long getReceivedMsgCount() {
        return this._receivedMsgCount;
    }

    public ReplyTime getReplyTime() {
        return this._replyTime;
    }

    public Long getSentMsgCount() {
        return this._sentMsgCount;
    }

    public Integer getUnknownMsgReceived() {
        return this._unknownMsgReceived;
    }

    public <E extends Augmentation<Messages>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MessagesBuilder setErrorMessages(ErrorMessages value) {
        this._errorMessages = value;
        return this;
    }

    private static void checkLastSentMsgTimestampRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public MessagesBuilder setLastSentMsgTimestamp(Long value) {
        if (value != null) {
            MessagesBuilder.checkLastSentMsgTimestampRange(value);
        }
        this._lastSentMsgTimestamp = value;
        return this;
    }

    private static void checkReceivedMsgCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public MessagesBuilder setReceivedMsgCount(Long value) {
        if (value != null) {
            MessagesBuilder.checkReceivedMsgCountRange(value);
        }
        this._receivedMsgCount = value;
        return this;
    }

    public MessagesBuilder setReplyTime(ReplyTime value) {
        this._replyTime = value;
        return this;
    }

    private static void checkSentMsgCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public MessagesBuilder setSentMsgCount(Long value) {
        if (value != null) {
            MessagesBuilder.checkSentMsgCountRange(value);
        }
        this._sentMsgCount = value;
        return this;
    }

    private static void checkUnknownMsgReceivedRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public MessagesBuilder setUnknownMsgReceived(Integer value) {
        if (value != null) {
            MessagesBuilder.checkUnknownMsgReceivedRange(value);
        }
        this._unknownMsgReceived = value;
        return this;
    }

    public MessagesBuilder addAugmentation(Class<? extends Augmentation<Messages>> augmentationType, Augmentation<Messages> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Messages>>, Augmentation<Messages>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MessagesBuilder removeAugmentation(Class<? extends Augmentation<Messages>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Messages build() {
        return new MessagesImpl(this);
    }

    private static final class MessagesImpl
    implements Messages {
        private final ErrorMessages _errorMessages;
        private final Long _lastSentMsgTimestamp;
        private final Long _receivedMsgCount;
        private final ReplyTime _replyTime;
        private final Long _sentMsgCount;
        private final Integer _unknownMsgReceived;
        private Map<Class<? extends Augmentation<Messages>>, Augmentation<Messages>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Messages> getImplementedInterface() {
            return Messages.class;
        }

        private MessagesImpl(MessagesBuilder base) {
            this._errorMessages = base.getErrorMessages();
            this._lastSentMsgTimestamp = base.getLastSentMsgTimestamp();
            this._receivedMsgCount = base.getReceivedMsgCount();
            this._replyTime = base.getReplyTime();
            this._sentMsgCount = base.getSentMsgCount();
            this._unknownMsgReceived = base.getUnknownMsgReceived();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Messages>>, Augmentation<Messages>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Messages>>, Augmentation<Messages>>(base.augmentation);
                }
            }
        }

        @Override
        public ErrorMessages getErrorMessages() {
            return this._errorMessages;
        }

        @Override
        public Long getLastSentMsgTimestamp() {
            return this._lastSentMsgTimestamp;
        }

        @Override
        public Long getReceivedMsgCount() {
            return this._receivedMsgCount;
        }

        @Override
        public ReplyTime getReplyTime() {
            return this._replyTime;
        }

        @Override
        public Long getSentMsgCount() {
            return this._sentMsgCount;
        }

        @Override
        public Integer getUnknownMsgReceived() {
            return this._unknownMsgReceived;
        }

        public <E extends Augmentation<Messages>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._errorMessages);
            result = 31 * result + Objects.hashCode(this._lastSentMsgTimestamp);
            result = 31 * result + Objects.hashCode(this._receivedMsgCount);
            result = 31 * result + Objects.hashCode(this._replyTime);
            result = 31 * result + Objects.hashCode(this._sentMsgCount);
            result = 31 * result + Objects.hashCode(this._unknownMsgReceived);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Messages.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Messages other = (Messages)obj;
            if (!Objects.equals(this._errorMessages, other.getErrorMessages())) {
                return false;
            }
            if (!Objects.equals(this._lastSentMsgTimestamp, other.getLastSentMsgTimestamp())) {
                return false;
            }
            if (!Objects.equals(this._receivedMsgCount, other.getReceivedMsgCount())) {
                return false;
            }
            if (!Objects.equals(this._replyTime, other.getReplyTime())) {
                return false;
            }
            if (!Objects.equals(this._sentMsgCount, other.getSentMsgCount())) {
                return false;
            }
            if (!Objects.equals(this._unknownMsgReceived, other.getUnknownMsgReceived())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MessagesImpl otherImpl = (MessagesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Messages>>, Augmentation<Messages>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Messages [";
            StringBuilder builder = new StringBuilder(name);
            if (this._errorMessages != null) {
                builder.append("_errorMessages=");
                builder.append(this._errorMessages);
                builder.append(", ");
            }
            if (this._lastSentMsgTimestamp != null) {
                builder.append("_lastSentMsgTimestamp=");
                builder.append(this._lastSentMsgTimestamp);
                builder.append(", ");
            }
            if (this._receivedMsgCount != null) {
                builder.append("_receivedMsgCount=");
                builder.append(this._receivedMsgCount);
                builder.append(", ");
            }
            if (this._replyTime != null) {
                builder.append("_replyTime=");
                builder.append(this._replyTime);
                builder.append(", ");
            }
            if (this._sentMsgCount != null) {
                builder.append("_sentMsgCount=");
                builder.append(this._sentMsgCount);
                builder.append(", ");
            }
            if (this._unknownMsgReceived != null) {
                builder.append("_unknownMsgReceived=");
                builder.append(this._unknownMsgReceived);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

