/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.Messages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.PeerCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.PeerPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.grouping.PcepSessionState;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcepSessionStateBuilder
implements Builder<PcepSessionState> {
    private Integer _delegatedLspsCount;
    private LocalPref _localPref;
    private Messages _messages;
    private PeerCapabilities _peerCapabilities;
    private PeerPref _peerPref;
    private String _sessionDuration;
    private Boolean _synchronized;
    Map<Class<? extends Augmentation<PcepSessionState>>, Augmentation<PcepSessionState>> augmentation = Collections.emptyMap();

    public PcepSessionStateBuilder() {
    }

    public PcepSessionStateBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState arg) {
        this._sessionDuration = arg.getSessionDuration();
        this._synchronized = arg.isSynchronized();
        this._peerCapabilities = arg.getPeerCapabilities();
        this._messages = arg.getMessages();
        this._localPref = arg.getLocalPref();
        this._peerPref = arg.getPeerPref();
        this._delegatedLspsCount = arg.getDelegatedLspsCount();
    }

    public PcepSessionStateBuilder(PcepSessionState base) {
        AugmentationHolder casted;
        this._delegatedLspsCount = base.getDelegatedLspsCount();
        this._localPref = base.getLocalPref();
        this._messages = base.getMessages();
        this._peerCapabilities = base.getPeerCapabilities();
        this._peerPref = base.getPeerPref();
        this._sessionDuration = base.getSessionDuration();
        this._synchronized = base.isSynchronized();
        if (base instanceof PcepSessionStateImpl) {
            PcepSessionStateImpl impl = (PcepSessionStateImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PcepSessionState>>, Augmentation<PcepSessionState>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepSessionState>>, Augmentation<PcepSessionState>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState) {
            this._sessionDuration = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState)arg).getSessionDuration();
            this._synchronized = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState)arg).isSynchronized();
            this._peerCapabilities = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState)arg).getPeerCapabilities();
            this._messages = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState)arg).getMessages();
            this._localPref = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState)arg).getLocalPref();
            this._peerPref = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState)arg).getPeerPref();
            this._delegatedLspsCount = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState)arg).getDelegatedLspsCount();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.PcepSessionState] \nbut was: " + arg);
        }
    }

    public Integer getDelegatedLspsCount() {
        return this._delegatedLspsCount;
    }

    public LocalPref getLocalPref() {
        return this._localPref;
    }

    public Messages getMessages() {
        return this._messages;
    }

    public PeerCapabilities getPeerCapabilities() {
        return this._peerCapabilities;
    }

    public PeerPref getPeerPref() {
        return this._peerPref;
    }

    public String getSessionDuration() {
        return this._sessionDuration;
    }

    public Boolean isSynchronized() {
        return this._synchronized;
    }

    public <E extends Augmentation<PcepSessionState>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDelegatedLspsCountRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public PcepSessionStateBuilder setDelegatedLspsCount(Integer value) {
        if (value != null) {
            PcepSessionStateBuilder.checkDelegatedLspsCountRange(value);
        }
        this._delegatedLspsCount = value;
        return this;
    }

    public PcepSessionStateBuilder setLocalPref(LocalPref value) {
        this._localPref = value;
        return this;
    }

    public PcepSessionStateBuilder setMessages(Messages value) {
        this._messages = value;
        return this;
    }

    public PcepSessionStateBuilder setPeerCapabilities(PeerCapabilities value) {
        this._peerCapabilities = value;
        return this;
    }

    public PcepSessionStateBuilder setPeerPref(PeerPref value) {
        this._peerPref = value;
        return this;
    }

    public PcepSessionStateBuilder setSessionDuration(String value) {
        this._sessionDuration = value;
        return this;
    }

    public PcepSessionStateBuilder setSynchronized(Boolean value) {
        this._synchronized = value;
        return this;
    }

    public PcepSessionStateBuilder addAugmentation(Class<? extends Augmentation<PcepSessionState>> augmentationType, Augmentation<PcepSessionState> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepSessionState>>, Augmentation<PcepSessionState>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PcepSessionStateBuilder removeAugmentation(Class<? extends Augmentation<PcepSessionState>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PcepSessionState build() {
        return new PcepSessionStateImpl(this);
    }

    private static final class PcepSessionStateImpl
    implements PcepSessionState {
        private final Integer _delegatedLspsCount;
        private final LocalPref _localPref;
        private final Messages _messages;
        private final PeerCapabilities _peerCapabilities;
        private final PeerPref _peerPref;
        private final String _sessionDuration;
        private final Boolean _synchronized;
        private Map<Class<? extends Augmentation<PcepSessionState>>, Augmentation<PcepSessionState>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PcepSessionState> getImplementedInterface() {
            return PcepSessionState.class;
        }

        private PcepSessionStateImpl(PcepSessionStateBuilder base) {
            this._delegatedLspsCount = base.getDelegatedLspsCount();
            this._localPref = base.getLocalPref();
            this._messages = base.getMessages();
            this._peerCapabilities = base.getPeerCapabilities();
            this._peerPref = base.getPeerPref();
            this._sessionDuration = base.getSessionDuration();
            this._synchronized = base.isSynchronized();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PcepSessionState>>, Augmentation<PcepSessionState>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PcepSessionState>>, Augmentation<PcepSessionState>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getDelegatedLspsCount() {
            return this._delegatedLspsCount;
        }

        @Override
        public LocalPref getLocalPref() {
            return this._localPref;
        }

        @Override
        public Messages getMessages() {
            return this._messages;
        }

        @Override
        public PeerCapabilities getPeerCapabilities() {
            return this._peerCapabilities;
        }

        @Override
        public PeerPref getPeerPref() {
            return this._peerPref;
        }

        @Override
        public String getSessionDuration() {
            return this._sessionDuration;
        }

        @Override
        public Boolean isSynchronized() {
            return this._synchronized;
        }

        public <E extends Augmentation<PcepSessionState>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._delegatedLspsCount);
            result = 31 * result + Objects.hashCode(this._localPref);
            result = 31 * result + Objects.hashCode(this._messages);
            result = 31 * result + Objects.hashCode(this._peerCapabilities);
            result = 31 * result + Objects.hashCode(this._peerPref);
            result = 31 * result + Objects.hashCode(this._sessionDuration);
            result = 31 * result + Objects.hashCode(this._synchronized);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcepSessionState.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcepSessionState other = (PcepSessionState)obj;
            if (!Objects.equals(this._delegatedLspsCount, other.getDelegatedLspsCount())) {
                return false;
            }
            if (!Objects.equals(this._localPref, other.getLocalPref())) {
                return false;
            }
            if (!Objects.equals(this._messages, other.getMessages())) {
                return false;
            }
            if (!Objects.equals(this._peerCapabilities, other.getPeerCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._peerPref, other.getPeerPref())) {
                return false;
            }
            if (!Objects.equals(this._sessionDuration, other.getSessionDuration())) {
                return false;
            }
            if (!Objects.equals(this._synchronized, other.isSynchronized())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcepSessionStateImpl otherImpl = (PcepSessionStateImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcepSessionState>>, Augmentation<PcepSessionState>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PcepSessionState [";
            StringBuilder builder = new StringBuilder(name);
            if (this._delegatedLspsCount != null) {
                builder.append("_delegatedLspsCount=");
                builder.append(this._delegatedLspsCount);
                builder.append(", ");
            }
            if (this._localPref != null) {
                builder.append("_localPref=");
                builder.append(this._localPref);
                builder.append(", ");
            }
            if (this._messages != null) {
                builder.append("_messages=");
                builder.append(this._messages);
                builder.append(", ");
            }
            if (this._peerCapabilities != null) {
                builder.append("_peerCapabilities=");
                builder.append(this._peerCapabilities);
                builder.append(", ");
            }
            if (this._peerPref != null) {
                builder.append("_peerPref=");
                builder.append(this._peerPref);
                builder.append(", ");
            }
            if (this._sessionDuration != null) {
                builder.append("_sessionDuration=");
                builder.append(this._sessionDuration);
                builder.append(", ");
            }
            if (this._synchronized != null) {
                builder.append("_synchronized=");
                builder.append(this._synchronized);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

