/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.ipv4._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.ipv4._case.Ipv4;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Ipv4Builder
implements Builder<Ipv4> {
    private Ipv4Address _destinationIpv4Address;
    private Ipv4Address _sourceIpv4Address;
    Map<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>> augmentation = Collections.emptyMap();

    public Ipv4Builder() {
    }

    public Ipv4Builder(Ipv4 base) {
        AugmentationHolder casted;
        this._destinationIpv4Address = base.getDestinationIpv4Address();
        this._sourceIpv4Address = base.getSourceIpv4Address();
        if (base instanceof Ipv4Impl) {
            Ipv4Impl impl = (Ipv4Impl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>>(casted.augmentations());
        }
    }

    public Ipv4Address getDestinationIpv4Address() {
        return this._destinationIpv4Address;
    }

    public Ipv4Address getSourceIpv4Address() {
        return this._sourceIpv4Address;
    }

    public <E extends Augmentation<Ipv4>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public Ipv4Builder setDestinationIpv4Address(Ipv4Address value) {
        this._destinationIpv4Address = value;
        return this;
    }

    public Ipv4Builder setSourceIpv4Address(Ipv4Address value) {
        this._sourceIpv4Address = value;
        return this;
    }

    public Ipv4Builder addAugmentation(Class<? extends Augmentation<Ipv4>> augmentationType, Augmentation<Ipv4> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Ipv4Builder removeAugmentation(Class<? extends Augmentation<Ipv4>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ipv4 build() {
        return new Ipv4Impl(this);
    }

    private static final class Ipv4Impl
    implements Ipv4 {
        private final Ipv4Address _destinationIpv4Address;
        private final Ipv4Address _sourceIpv4Address;
        private Map<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Ipv4> getImplementedInterface() {
            return Ipv4.class;
        }

        private Ipv4Impl(Ipv4Builder base) {
            this._destinationIpv4Address = base.getDestinationIpv4Address();
            this._sourceIpv4Address = base.getSourceIpv4Address();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv4Address getDestinationIpv4Address() {
            return this._destinationIpv4Address;
        }

        @Override
        public Ipv4Address getSourceIpv4Address() {
            return this._sourceIpv4Address;
        }

        public <E extends Augmentation<Ipv4>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._destinationIpv4Address);
            result = 31 * result + Objects.hashCode(this._sourceIpv4Address);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ipv4.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ipv4 other = (Ipv4)obj;
            if (!Objects.equals(this._destinationIpv4Address, other.getDestinationIpv4Address())) {
                return false;
            }
            if (!Objects.equals(this._sourceIpv4Address, other.getSourceIpv4Address())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Ipv4Impl otherImpl = (Ipv4Impl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Ipv4 [";
            StringBuilder builder = new StringBuilder(name);
            if (this._destinationIpv4Address != null) {
                builder.append("_destinationIpv4Address=");
                builder.append(this._destinationIpv4Address);
                builder.append(", ");
            }
            if (this._sourceIpv4Address != null) {
                builder.append("_sourceIpv4Address=");
                builder.append(this._sourceIpv4Address);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

