/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.ipv6._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.ipv6._case.Ipv6;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Ipv6Builder
implements Builder<Ipv6> {
    private Ipv6Address _destinationIpv6Address;
    private Ipv6Address _sourceIpv6Address;
    Map<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> augmentation = Collections.emptyMap();

    public Ipv6Builder() {
    }

    public Ipv6Builder(Ipv6 base) {
        AugmentationHolder casted;
        this._destinationIpv6Address = base.getDestinationIpv6Address();
        this._sourceIpv6Address = base.getSourceIpv6Address();
        if (base instanceof Ipv6Impl) {
            Ipv6Impl impl = (Ipv6Impl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>(casted.augmentations());
        }
    }

    public Ipv6Address getDestinationIpv6Address() {
        return this._destinationIpv6Address;
    }

    public Ipv6Address getSourceIpv6Address() {
        return this._sourceIpv6Address;
    }

    public <E extends Augmentation<Ipv6>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public Ipv6Builder setDestinationIpv6Address(Ipv6Address value) {
        this._destinationIpv6Address = value;
        return this;
    }

    public Ipv6Builder setSourceIpv6Address(Ipv6Address value) {
        this._sourceIpv6Address = value;
        return this;
    }

    public Ipv6Builder addAugmentation(Class<? extends Augmentation<Ipv6>> augmentationType, Augmentation<Ipv6> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Ipv6Builder removeAugmentation(Class<? extends Augmentation<Ipv6>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ipv6 build() {
        return new Ipv6Impl(this);
    }

    private static final class Ipv6Impl
    implements Ipv6 {
        private final Ipv6Address _destinationIpv6Address;
        private final Ipv6Address _sourceIpv6Address;
        private Map<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Ipv6> getImplementedInterface() {
            return Ipv6.class;
        }

        private Ipv6Impl(Ipv6Builder base) {
            this._destinationIpv6Address = base.getDestinationIpv6Address();
            this._sourceIpv6Address = base.getSourceIpv6Address();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>(base.augmentation);
                }
            }
        }

        @Override
        public Ipv6Address getDestinationIpv6Address() {
            return this._destinationIpv6Address;
        }

        @Override
        public Ipv6Address getSourceIpv6Address() {
            return this._sourceIpv6Address;
        }

        public <E extends Augmentation<Ipv6>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._destinationIpv6Address);
            result = 31 * result + Objects.hashCode(this._sourceIpv6Address);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ipv6.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ipv6 other = (Ipv6)obj;
            if (!Objects.equals(this._destinationIpv6Address, other.getDestinationIpv6Address())) {
                return false;
            }
            if (!Objects.equals(this._sourceIpv6Address, other.getSourceIpv6Address())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Ipv6Impl otherImpl = (Ipv6Impl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Ipv6 [";
            StringBuilder builder = new StringBuilder(name);
            if (this._destinationIpv6Address != null) {
                builder.append("_destinationIpv6Address=");
                builder.append(this._destinationIpv6Address);
                builder.append(", ");
            }
            if (this._sourceIpv6Address != null) {
                builder.append("_sourceIpv6Address=");
                builder.append(this._sourceIpv6Address);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

