/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.exclude.route.object.xro.Subobject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class XroBuilder
implements Builder<Xro> {
    private Xro.Flags _flags;
    private List<Subobject> _subobject;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<Xro>>, Augmentation<Xro>> augmentation = Collections.emptyMap();

    public XroBuilder() {
    }

    public XroBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public XroBuilder(Xro base) {
        AugmentationHolder casted;
        this._flags = base.getFlags();
        this._subobject = base.getSubobject();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof XroImpl) {
            XroImpl impl = (XroImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Xro>>, Augmentation<Xro>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Xro>>, Augmentation<Xro>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public Xro.Flags getFlags() {
        return this._flags;
    }

    public List<Subobject> getSubobject() {
        return this._subobject;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<Xro>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public XroBuilder setFlags(Xro.Flags value) {
        this._flags = value;
        return this;
    }

    public XroBuilder setSubobject(List<Subobject> value) {
        this._subobject = value;
        return this;
    }

    public XroBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public XroBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public XroBuilder addAugmentation(Class<? extends Augmentation<Xro>> augmentationType, Augmentation<Xro> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Xro>>, Augmentation<Xro>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public XroBuilder removeAugmentation(Class<? extends Augmentation<Xro>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Xro build() {
        return new XroImpl(this);
    }

    private static final class XroImpl
    implements Xro {
        private final Xro.Flags _flags;
        private final List<Subobject> _subobject;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<Xro>>, Augmentation<Xro>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Xro> getImplementedInterface() {
            return Xro.class;
        }

        private XroImpl(XroBuilder base) {
            this._flags = base.getFlags();
            this._subobject = base.getSubobject();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Xro>>, Augmentation<Xro>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Xro>>, Augmentation<Xro>>(base.augmentation);
                }
            }
        }

        @Override
        public Xro.Flags getFlags() {
            return this._flags;
        }

        @Override
        public List<Subobject> getSubobject() {
            return this._subobject;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<Xro>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._subobject);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Xro.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Xro other = (Xro)obj;
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._subobject, other.getSubobject())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                XroImpl otherImpl = (XroImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Xro>>, Augmentation<Xro>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Xro [";
            StringBuilder builder = new StringBuilder(name);
            if (this._flags != null) {
                builder.append("_flags=");
                builder.append(this._flags);
                builder.append(", ");
            }
            if (this._subobject != null) {
                builder.append("_subobject=");
                builder.append(this._subobject);
                builder.append(", ");
            }
            if (this._ignore != null) {
                builder.append("_ignore=");
                builder.append(this._ignore);
                builder.append(", ");
            }
            if (this._processingRule != null) {
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

