/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.load.balancing.object;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.load.balancing.object.LoadBalancing;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LoadBalancingBuilder
implements Builder<LoadBalancing> {
    private Short _maxLsp;
    private Bandwidth _minBandwidth;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>> augmentation = Collections.emptyMap();

    public LoadBalancingBuilder() {
    }

    public LoadBalancingBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public LoadBalancingBuilder(LoadBalancing base) {
        AugmentationHolder casted;
        this._maxLsp = base.getMaxLsp();
        this._minBandwidth = base.getMinBandwidth();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof LoadBalancingImpl) {
            LoadBalancingImpl impl = (LoadBalancingImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public Short getMaxLsp() {
        return this._maxLsp;
    }

    public Bandwidth getMinBandwidth() {
        return this._minBandwidth;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<LoadBalancing>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMaxLspRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public LoadBalancingBuilder setMaxLsp(Short value) {
        if (value != null) {
            LoadBalancingBuilder.checkMaxLspRange(value);
        }
        this._maxLsp = value;
        return this;
    }

    public LoadBalancingBuilder setMinBandwidth(Bandwidth value) {
        this._minBandwidth = value;
        return this;
    }

    public LoadBalancingBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public LoadBalancingBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public LoadBalancingBuilder addAugmentation(Class<? extends Augmentation<LoadBalancing>> augmentationType, Augmentation<LoadBalancing> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public LoadBalancingBuilder removeAugmentation(Class<? extends Augmentation<LoadBalancing>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public LoadBalancing build() {
        return new LoadBalancingImpl(this);
    }

    private static final class LoadBalancingImpl
    implements LoadBalancing {
        private final Short _maxLsp;
        private final Bandwidth _minBandwidth;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<LoadBalancing> getImplementedInterface() {
            return LoadBalancing.class;
        }

        private LoadBalancingImpl(LoadBalancingBuilder base) {
            this._maxLsp = base.getMaxLsp();
            this._minBandwidth = base.getMinBandwidth();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getMaxLsp() {
            return this._maxLsp;
        }

        @Override
        public Bandwidth getMinBandwidth() {
            return this._minBandwidth;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<LoadBalancing>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._maxLsp);
            result = 31 * result + Objects.hashCode(this._minBandwidth);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LoadBalancing.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LoadBalancing other = (LoadBalancing)obj;
            if (!Objects.equals(this._maxLsp, other.getMaxLsp())) {
                return false;
            }
            if (!Objects.equals(this._minBandwidth, other.getMinBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LoadBalancingImpl otherImpl = (LoadBalancingImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LoadBalancing>>, Augmentation<LoadBalancing>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "LoadBalancing [";
            StringBuilder builder = new StringBuilder(name);
            if (this._maxLsp != null) {
                builder.append("_maxLsp=");
                builder.append(this._maxLsp);
                builder.append(", ");
            }
            if (this._minBandwidth != null) {
                builder.append("_minBandwidth=");
                builder.append(this._minBandwidth);
                builder.append(", ");
            }
            if (this._ignore != null) {
                builder.append("_ignore=");
                builder.append(this._ignore);
                builder.append(", ");
            }
            if (this._processingRule != null) {
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

