/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MetricObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MetricsBuilder
implements Builder<Metrics> {
    private Metric _metric;
    Map<Class<? extends Augmentation<Metrics>>, Augmentation<Metrics>> augmentation = Collections.emptyMap();

    public MetricsBuilder() {
    }

    public MetricsBuilder(MetricObject arg) {
        this._metric = arg.getMetric();
    }

    public MetricsBuilder(Metrics base) {
        AugmentationHolder casted;
        this._metric = base.getMetric();
        if (base instanceof MetricsImpl) {
            MetricsImpl impl = (MetricsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Metrics>>, Augmentation<Metrics>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Metrics>>, Augmentation<Metrics>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MetricObject) {
            this._metric = ((MetricObject)arg).getMetric();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MetricObject] \nbut was: " + arg);
        }
    }

    public Metric getMetric() {
        return this._metric;
    }

    public <E extends Augmentation<Metrics>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MetricsBuilder setMetric(Metric value) {
        this._metric = value;
        return this;
    }

    public MetricsBuilder addAugmentation(Class<? extends Augmentation<Metrics>> augmentationType, Augmentation<Metrics> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Metrics>>, Augmentation<Metrics>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MetricsBuilder removeAugmentation(Class<? extends Augmentation<Metrics>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Metrics build() {
        return new MetricsImpl(this);
    }

    private static final class MetricsImpl
    implements Metrics {
        private final Metric _metric;
        private Map<Class<? extends Augmentation<Metrics>>, Augmentation<Metrics>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Metrics> getImplementedInterface() {
            return Metrics.class;
        }

        private MetricsImpl(MetricsBuilder base) {
            this._metric = base.getMetric();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Metrics>>, Augmentation<Metrics>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Metrics>>, Augmentation<Metrics>>(base.augmentation);
                }
            }
        }

        @Override
        public Metric getMetric() {
            return this._metric;
        }

        public <E extends Augmentation<Metrics>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._metric);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Metrics.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Metrics other = (Metrics)obj;
            if (!Objects.equals(this._metric, other.getMetric())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MetricsImpl otherImpl = (MetricsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Metrics>>, Augmentation<Metrics>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Metrics [";
            StringBuilder builder = new StringBuilder(name);
            if (this._metric != null) {
                builder.append("_metric=");
                builder.append(this._metric);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

