/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.object.of.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OfBuilder
implements Builder<Of> {
    private OfId _code;
    private Tlvs _tlvs;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<Of>>, Augmentation<Of>> augmentation = Collections.emptyMap();

    public OfBuilder() {
    }

    public OfBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public OfBuilder(Of base) {
        AugmentationHolder casted;
        this._code = base.getCode();
        this._tlvs = base.getTlvs();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof OfImpl) {
            OfImpl impl = (OfImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Of>>, Augmentation<Of>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Of>>, Augmentation<Of>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public OfId getCode() {
        return this._code;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<Of>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OfBuilder setCode(OfId value) {
        this._code = value;
        return this;
    }

    public OfBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public OfBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public OfBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public OfBuilder addAugmentation(Class<? extends Augmentation<Of>> augmentationType, Augmentation<Of> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Of>>, Augmentation<Of>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OfBuilder removeAugmentation(Class<? extends Augmentation<Of>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Of build() {
        return new OfImpl(this);
    }

    private static final class OfImpl
    implements Of {
        private final OfId _code;
        private final Tlvs _tlvs;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<Of>>, Augmentation<Of>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Of> getImplementedInterface() {
            return Of.class;
        }

        private OfImpl(OfBuilder base) {
            this._code = base.getCode();
            this._tlvs = base.getTlvs();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Of>>, Augmentation<Of>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Of>>, Augmentation<Of>>(base.augmentation);
                }
            }
        }

        @Override
        public OfId getCode() {
            return this._code;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<Of>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._code);
            result = 31 * result + Objects.hashCode(this._tlvs);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Of.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Of other = (Of)obj;
            if (!Objects.equals(this._code, other.getCode())) {
                return false;
            }
            if (!Objects.equals(this._tlvs, other.getTlvs())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OfImpl otherImpl = (OfImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Of>>, Augmentation<Of>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Of [";
            StringBuilder builder = new StringBuilder(name);
            if (this._code != null) {
                builder.append("_code=");
                builder.append(this._code);
                builder.append(", ");
            }
            if (this._tlvs != null) {
                builder.append("_tlvs=");
                builder.append(this._tlvs);
                builder.append(", ");
            }
            if (this._ignore != null) {
                builder.append("_ignore=");
                builder.append(this._ignore);
                builder.append(", ");
            }
            if (this._processingRule != null) {
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

