/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.message;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OpenObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.message.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OpenMessageBuilder
implements Builder<OpenMessage> {
    private Open _open;
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>> augmentation = Collections.emptyMap();

    public OpenMessageBuilder() {
    }

    public OpenMessageBuilder(OpenObject arg) {
        this._open = arg.getOpen();
    }

    public OpenMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public OpenMessageBuilder(OpenMessage base) {
        AugmentationHolder casted;
        this._open = base.getOpen();
        this._version = base.getVersion();
        if (base instanceof OpenMessageImpl) {
            OpenMessageImpl impl = (OpenMessageImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenObject) {
            this._open = ((OpenObject)arg).getOpen();
            isValidArg = true;
        }
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OpenObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader] \nbut was: " + arg);
        }
    }

    public Open getOpen() {
        return this._open;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E extends Augmentation<OpenMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OpenMessageBuilder setOpen(Open value) {
        this._open = value;
        return this;
    }

    public OpenMessageBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public OpenMessageBuilder addAugmentation(Class<? extends Augmentation<OpenMessage>> augmentationType, Augmentation<OpenMessage> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OpenMessageBuilder removeAugmentation(Class<? extends Augmentation<OpenMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OpenMessage build() {
        return new OpenMessageImpl(this);
    }

    private static final class OpenMessageImpl
    implements OpenMessage {
        private final Open _open;
        private final ProtocolVersion _version;
        private Map<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<OpenMessage> getImplementedInterface() {
            return OpenMessage.class;
        }

        private OpenMessageImpl(OpenMessageBuilder base) {
            this._open = base.getOpen();
            this._version = base.getVersion();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public Open getOpen() {
            return this._open;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        public <E extends Augmentation<OpenMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._open);
            result = 31 * result + Objects.hashCode(this._version);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OpenMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OpenMessage other = (OpenMessage)obj;
            if (!Objects.equals(this._open, other.getOpen())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OpenMessageImpl otherImpl = (OpenMessageImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "OpenMessage [";
            StringBuilder builder = new StringBuilder(name);
            if (this._open != null) {
                builder.append("_open=");
                builder.append(this._open);
                builder.append(", ");
            }
            if (this._version != null) {
                builder.append("_version=");
                builder.append(this._version);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

