/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.overload.duration.tlv;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.overload.duration.tlv.OverloadDuration;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OverloadDurationBuilder
implements Builder<OverloadDuration> {
    private Long _duration;
    Map<Class<? extends Augmentation<OverloadDuration>>, Augmentation<OverloadDuration>> augmentation = Collections.emptyMap();

    public OverloadDurationBuilder() {
    }

    public OverloadDurationBuilder(OverloadDuration base) {
        AugmentationHolder casted;
        this._duration = base.getDuration();
        if (base instanceof OverloadDurationImpl) {
            OverloadDurationImpl impl = (OverloadDurationImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OverloadDuration>>, Augmentation<OverloadDuration>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OverloadDuration>>, Augmentation<OverloadDuration>>(casted.augmentations());
        }
    }

    public Long getDuration() {
        return this._duration;
    }

    public <E extends Augmentation<OverloadDuration>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDurationRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public OverloadDurationBuilder setDuration(Long value) {
        if (value != null) {
            OverloadDurationBuilder.checkDurationRange(value);
        }
        this._duration = value;
        return this;
    }

    public OverloadDurationBuilder addAugmentation(Class<? extends Augmentation<OverloadDuration>> augmentationType, Augmentation<OverloadDuration> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OverloadDuration>>, Augmentation<OverloadDuration>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OverloadDurationBuilder removeAugmentation(Class<? extends Augmentation<OverloadDuration>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OverloadDuration build() {
        return new OverloadDurationImpl(this);
    }

    private static final class OverloadDurationImpl
    implements OverloadDuration {
        private final Long _duration;
        private Map<Class<? extends Augmentation<OverloadDuration>>, Augmentation<OverloadDuration>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<OverloadDuration> getImplementedInterface() {
            return OverloadDuration.class;
        }

        private OverloadDurationImpl(OverloadDurationBuilder base) {
            this._duration = base.getDuration();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<OverloadDuration>>, Augmentation<OverloadDuration>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<OverloadDuration>>, Augmentation<OverloadDuration>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getDuration() {
            return this._duration;
        }

        public <E extends Augmentation<OverloadDuration>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._duration);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OverloadDuration.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OverloadDuration other = (OverloadDuration)obj;
            if (!Objects.equals(this._duration, other.getDuration())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OverloadDurationImpl otherImpl = (OverloadDurationImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OverloadDuration>>, Augmentation<OverloadDuration>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "OverloadDuration [";
            StringBuilder builder = new StringBuilder(name);
            if (this._duration != null) {
                builder.append("_duration=");
                builder.append(this._duration);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

