/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.setup.type.tlv;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.setup.type.tlv.PathSetupType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PathSetupTypeBuilder
implements Builder<PathSetupType> {
    private Short _pst;
    Map<Class<? extends Augmentation<PathSetupType>>, Augmentation<PathSetupType>> augmentation = Collections.emptyMap();

    public PathSetupTypeBuilder() {
    }

    public PathSetupTypeBuilder(PathSetupType base) {
        AugmentationHolder casted;
        this._pst = base.getPst();
        if (base instanceof PathSetupTypeImpl) {
            PathSetupTypeImpl impl = (PathSetupTypeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PathSetupType>>, Augmentation<PathSetupType>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PathSetupType>>, Augmentation<PathSetupType>>(casted.augmentations());
        }
    }

    public Short getPst() {
        return this._pst;
    }

    public <E extends Augmentation<PathSetupType>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkPstRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public PathSetupTypeBuilder setPst(Short value) {
        if (value != null) {
            PathSetupTypeBuilder.checkPstRange(value);
        }
        this._pst = value;
        return this;
    }

    public PathSetupTypeBuilder addAugmentation(Class<? extends Augmentation<PathSetupType>> augmentationType, Augmentation<PathSetupType> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PathSetupType>>, Augmentation<PathSetupType>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PathSetupTypeBuilder removeAugmentation(Class<? extends Augmentation<PathSetupType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PathSetupType build() {
        return new PathSetupTypeImpl(this);
    }

    private static final class PathSetupTypeImpl
    implements PathSetupType {
        private final Short _pst;
        private Map<Class<? extends Augmentation<PathSetupType>>, Augmentation<PathSetupType>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PathSetupType> getImplementedInterface() {
            return PathSetupType.class;
        }

        private PathSetupTypeImpl(PathSetupTypeBuilder base) {
            this._pst = base.getPst();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PathSetupType>>, Augmentation<PathSetupType>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PathSetupType>>, Augmentation<PathSetupType>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getPst() {
            return this._pst;
        }

        public <E extends Augmentation<PathSetupType>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._pst);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PathSetupType.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PathSetupType other = (PathSetupType)obj;
            if (!Objects.equals(this._pst, other.getPst())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PathSetupTypeImpl otherImpl = (PathSetupTypeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PathSetupType>>, Augmentation<PathSetupType>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PathSetupType [";
            StringBuilder builder = new StringBuilder(name);
            if (this._pst != null) {
                builder.append("_pst=");
                builder.append(this._pst);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

