/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.NoPathObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.NoPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.result.failure._case.no.path.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NoPathBuilder
implements Builder<NoPath> {
    private Short _natureOfIssue;
    private Tlvs _tlvs;
    private Boolean _ignore;
    private Boolean _processingRule;
    private Boolean _unsatisfiedConstraints;
    Map<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>> augmentation = Collections.emptyMap();

    public NoPathBuilder() {
    }

    public NoPathBuilder(NoPathObject arg) {
        this._natureOfIssue = arg.getNatureOfIssue();
        this._unsatisfiedConstraints = arg.isUnsatisfiedConstraints();
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public NoPathBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public NoPathBuilder(NoPath base) {
        AugmentationHolder casted;
        this._natureOfIssue = base.getNatureOfIssue();
        this._tlvs = base.getTlvs();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        this._unsatisfiedConstraints = base.isUnsatisfiedConstraints();
        if (base instanceof NoPathImpl) {
            NoPathImpl impl = (NoPathImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NoPathObject) {
            this._natureOfIssue = ((NoPathObject)arg).getNatureOfIssue();
            this._unsatisfiedConstraints = ((NoPathObject)arg).isUnsatisfiedConstraints();
            isValidArg = true;
        }
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.NoPathObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public Short getNatureOfIssue() {
        return this._natureOfIssue;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public Boolean isUnsatisfiedConstraints() {
        return this._unsatisfiedConstraints;
    }

    public <E extends Augmentation<NoPath>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkNatureOfIssueRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public NoPathBuilder setNatureOfIssue(Short value) {
        if (value != null) {
            NoPathBuilder.checkNatureOfIssueRange(value);
        }
        this._natureOfIssue = value;
        return this;
    }

    public NoPathBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public NoPathBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public NoPathBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public NoPathBuilder setUnsatisfiedConstraints(Boolean value) {
        this._unsatisfiedConstraints = value;
        return this;
    }

    public NoPathBuilder addAugmentation(Class<? extends Augmentation<NoPath>> augmentationType, Augmentation<NoPath> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NoPathBuilder removeAugmentation(Class<? extends Augmentation<NoPath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NoPath build() {
        return new NoPathImpl(this);
    }

    private static final class NoPathImpl
    implements NoPath {
        private final Short _natureOfIssue;
        private final Tlvs _tlvs;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private final Boolean _unsatisfiedConstraints;
        private Map<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NoPath> getImplementedInterface() {
            return NoPath.class;
        }

        private NoPathImpl(NoPathBuilder base) {
            this._natureOfIssue = base.getNatureOfIssue();
            this._tlvs = base.getTlvs();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            this._unsatisfiedConstraints = base.isUnsatisfiedConstraints();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getNatureOfIssue() {
            return this._natureOfIssue;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Boolean isUnsatisfiedConstraints() {
            return this._unsatisfiedConstraints;
        }

        public <E extends Augmentation<NoPath>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._natureOfIssue);
            result = 31 * result + Objects.hashCode(this._tlvs);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            result = 31 * result + Objects.hashCode(this._unsatisfiedConstraints);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NoPath.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NoPath other = (NoPath)obj;
            if (!Objects.equals(this._natureOfIssue, other.getNatureOfIssue())) {
                return false;
            }
            if (!Objects.equals(this._tlvs, other.getTlvs())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (!Objects.equals(this._unsatisfiedConstraints, other.isUnsatisfiedConstraints())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NoPathImpl otherImpl = (NoPathImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NoPath>>, Augmentation<NoPath>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NoPath [";
            StringBuilder builder = new StringBuilder(name);
            if (this._natureOfIssue != null) {
                builder.append("_natureOfIssue=");
                builder.append(this._natureOfIssue);
                builder.append(", ");
            }
            if (this._tlvs != null) {
                builder.append("_tlvs=");
                builder.append(this._tlvs);
                builder.append(", ");
            }
            if (this._ignore != null) {
                builder.append("_ignore=");
                builder.append(this._ignore);
                builder.append(", ");
            }
            if (this._processingRule != null) {
                builder.append("_processingRule=");
                builder.append(this._processingRule);
                builder.append(", ");
            }
            if (this._unsatisfiedConstraints != null) {
                builder.append("_unsatisfiedConstraints=");
                builder.append(this._unsatisfiedConstraints);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

