/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.PcreqMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.MonitoringRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.Svec;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcreqMessageBuilder
implements Builder<PcreqMessage> {
    private MonitoringRequest _monitoringRequest;
    private List<Requests> _requests;
    private List<Svec> _svec;
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>> augmentation = Collections.emptyMap();

    public PcreqMessageBuilder() {
    }

    public PcreqMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public PcreqMessageBuilder(PcreqMessage base) {
        AugmentationHolder casted;
        this._monitoringRequest = base.getMonitoringRequest();
        this._requests = base.getRequests();
        this._svec = base.getSvec();
        this._version = base.getVersion();
        if (base instanceof PcreqMessageImpl) {
            PcreqMessageImpl impl = (PcreqMessageImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader] \nbut was: " + arg);
        }
    }

    public MonitoringRequest getMonitoringRequest() {
        return this._monitoringRequest;
    }

    public List<Requests> getRequests() {
        return this._requests;
    }

    public List<Svec> getSvec() {
        return this._svec;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E extends Augmentation<PcreqMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PcreqMessageBuilder setMonitoringRequest(MonitoringRequest value) {
        this._monitoringRequest = value;
        return this;
    }

    public PcreqMessageBuilder setRequests(List<Requests> value) {
        this._requests = value;
        return this;
    }

    public PcreqMessageBuilder setSvec(List<Svec> value) {
        this._svec = value;
        return this;
    }

    public PcreqMessageBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public PcreqMessageBuilder addAugmentation(Class<? extends Augmentation<PcreqMessage>> augmentationType, Augmentation<PcreqMessage> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PcreqMessageBuilder removeAugmentation(Class<? extends Augmentation<PcreqMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PcreqMessage build() {
        return new PcreqMessageImpl(this);
    }

    private static final class PcreqMessageImpl
    implements PcreqMessage {
        private final MonitoringRequest _monitoringRequest;
        private final List<Requests> _requests;
        private final List<Svec> _svec;
        private final ProtocolVersion _version;
        private Map<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PcreqMessage> getImplementedInterface() {
            return PcreqMessage.class;
        }

        private PcreqMessageImpl(PcreqMessageBuilder base) {
            this._monitoringRequest = base.getMonitoringRequest();
            this._requests = base.getRequests();
            this._svec = base.getSvec();
            this._version = base.getVersion();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public MonitoringRequest getMonitoringRequest() {
            return this._monitoringRequest;
        }

        @Override
        public List<Requests> getRequests() {
            return this._requests;
        }

        @Override
        public List<Svec> getSvec() {
            return this._svec;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        public <E extends Augmentation<PcreqMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._monitoringRequest);
            result = 31 * result + Objects.hashCode(this._requests);
            result = 31 * result + Objects.hashCode(this._svec);
            result = 31 * result + Objects.hashCode(this._version);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcreqMessage.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcreqMessage other = (PcreqMessage)obj;
            if (!Objects.equals(this._monitoringRequest, other.getMonitoringRequest())) {
                return false;
            }
            if (!Objects.equals(this._requests, other.getRequests())) {
                return false;
            }
            if (!Objects.equals(this._svec, other.getSvec())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcreqMessageImpl otherImpl = (PcreqMessageImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcreqMessage>>, Augmentation<PcreqMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PcreqMessage [";
            StringBuilder builder = new StringBuilder(name);
            if (this._monitoringRequest != null) {
                builder.append("_monitoringRequest=");
                builder.append(this._monitoringRequest);
                builder.append(", ");
            }
            if (this._requests != null) {
                builder.append("_requests=");
                builder.append(this._requests);
                builder.append(", ");
            }
            if (this._svec != null) {
                builder.append("_svec=");
                builder.append(this._svec);
                builder.append(", ");
            }
            if (this._version != null) {
                builder.append("_version=");
                builder.append(this._version);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

