/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MonitoringObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PccIdReqObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcc.id.req.object.PccIdReq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.MonitoringRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.monitoring.request.PceIdList;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MonitoringRequestBuilder
implements Builder<MonitoringRequest> {
    private Monitoring _monitoring;
    private PccIdReq _pccIdReq;
    private List<PceIdList> _pceIdList;
    Map<Class<? extends Augmentation<MonitoringRequest>>, Augmentation<MonitoringRequest>> augmentation = Collections.emptyMap();

    public MonitoringRequestBuilder() {
    }

    public MonitoringRequestBuilder(PccIdReqObject arg) {
        this._pccIdReq = arg.getPccIdReq();
    }

    public MonitoringRequestBuilder(MonitoringObject arg) {
        this._monitoring = arg.getMonitoring();
    }

    public MonitoringRequestBuilder(MonitoringRequest base) {
        AugmentationHolder casted;
        this._monitoring = base.getMonitoring();
        this._pccIdReq = base.getPccIdReq();
        this._pceIdList = base.getPceIdList();
        if (base instanceof MonitoringRequestImpl) {
            MonitoringRequestImpl impl = (MonitoringRequestImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MonitoringRequest>>, Augmentation<MonitoringRequest>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MonitoringRequest>>, Augmentation<MonitoringRequest>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PccIdReqObject) {
            this._pccIdReq = ((PccIdReqObject)arg).getPccIdReq();
            isValidArg = true;
        }
        if (arg instanceof MonitoringObject) {
            this._monitoring = ((MonitoringObject)arg).getMonitoring();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PccIdReqObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MonitoringObject] \nbut was: " + arg);
        }
    }

    public Monitoring getMonitoring() {
        return this._monitoring;
    }

    public PccIdReq getPccIdReq() {
        return this._pccIdReq;
    }

    public List<PceIdList> getPceIdList() {
        return this._pceIdList;
    }

    public <E extends Augmentation<MonitoringRequest>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MonitoringRequestBuilder setMonitoring(Monitoring value) {
        this._monitoring = value;
        return this;
    }

    public MonitoringRequestBuilder setPccIdReq(PccIdReq value) {
        this._pccIdReq = value;
        return this;
    }

    public MonitoringRequestBuilder setPceIdList(List<PceIdList> value) {
        this._pceIdList = value;
        return this;
    }

    public MonitoringRequestBuilder addAugmentation(Class<? extends Augmentation<MonitoringRequest>> augmentationType, Augmentation<MonitoringRequest> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MonitoringRequest>>, Augmentation<MonitoringRequest>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MonitoringRequestBuilder removeAugmentation(Class<? extends Augmentation<MonitoringRequest>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MonitoringRequest build() {
        return new MonitoringRequestImpl(this);
    }

    private static final class MonitoringRequestImpl
    implements MonitoringRequest {
        private final Monitoring _monitoring;
        private final PccIdReq _pccIdReq;
        private final List<PceIdList> _pceIdList;
        private Map<Class<? extends Augmentation<MonitoringRequest>>, Augmentation<MonitoringRequest>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MonitoringRequest> getImplementedInterface() {
            return MonitoringRequest.class;
        }

        private MonitoringRequestImpl(MonitoringRequestBuilder base) {
            this._monitoring = base.getMonitoring();
            this._pccIdReq = base.getPccIdReq();
            this._pceIdList = base.getPceIdList();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MonitoringRequest>>, Augmentation<MonitoringRequest>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MonitoringRequest>>, Augmentation<MonitoringRequest>>(base.augmentation);
                }
            }
        }

        @Override
        public Monitoring getMonitoring() {
            return this._monitoring;
        }

        @Override
        public PccIdReq getPccIdReq() {
            return this._pccIdReq;
        }

        @Override
        public List<PceIdList> getPceIdList() {
            return this._pceIdList;
        }

        public <E extends Augmentation<MonitoringRequest>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._monitoring);
            result = 31 * result + Objects.hashCode(this._pccIdReq);
            result = 31 * result + Objects.hashCode(this._pceIdList);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MonitoringRequest.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MonitoringRequest other = (MonitoringRequest)obj;
            if (!Objects.equals(this._monitoring, other.getMonitoring())) {
                return false;
            }
            if (!Objects.equals(this._pccIdReq, other.getPccIdReq())) {
                return false;
            }
            if (!Objects.equals(this._pceIdList, other.getPceIdList())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MonitoringRequestImpl otherImpl = (MonitoringRequestImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MonitoringRequest>>, Augmentation<MonitoringRequest>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "MonitoringRequest [";
            StringBuilder builder = new StringBuilder(name);
            if (this._monitoring != null) {
                builder.append("_monitoring=");
                builder.append(this._monitoring);
                builder.append(", ");
            }
            if (this._pccIdReq != null) {
                builder.append("_pccIdReq=");
                builder.append(this._pccIdReq);
                builder.append(", ");
            }
            if (this._pceIdList != null) {
                builder.append("_pceIdList=");
                builder.append(this._pceIdList);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

