/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VendorInformationObjectBuilder
implements Builder<VendorInformationObject> {
    private EnterpriseNumber _enterpriseNumber;
    private EnterpriseSpecificInformation _enterpriseSpecificInformation;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>> augmentation = Collections.emptyMap();

    public VendorInformationObjectBuilder() {
    }

    public VendorInformationObjectBuilder(VendorInformation arg) {
        this._enterpriseNumber = arg.getEnterpriseNumber();
        this._enterpriseSpecificInformation = arg.getEnterpriseSpecificInformation();
    }

    public VendorInformationObjectBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public VendorInformationObjectBuilder(VendorInformationObject base) {
        AugmentationHolder casted;
        this._enterpriseNumber = base.getEnterpriseNumber();
        this._enterpriseSpecificInformation = base.getEnterpriseSpecificInformation();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof VendorInformationObjectImpl) {
            VendorInformationObjectImpl impl = (VendorInformationObjectImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof VendorInformation) {
            this._enterpriseNumber = ((VendorInformation)arg).getEnterpriseNumber();
            this._enterpriseSpecificInformation = ((VendorInformation)arg).getEnterpriseSpecificInformation();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformation] \nbut was: " + arg);
        }
    }

    public EnterpriseNumber getEnterpriseNumber() {
        return this._enterpriseNumber;
    }

    public EnterpriseSpecificInformation getEnterpriseSpecificInformation() {
        return this._enterpriseSpecificInformation;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<VendorInformationObject>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public VendorInformationObjectBuilder setEnterpriseNumber(EnterpriseNumber value) {
        this._enterpriseNumber = value;
        return this;
    }

    public VendorInformationObjectBuilder setEnterpriseSpecificInformation(EnterpriseSpecificInformation value) {
        this._enterpriseSpecificInformation = value;
        return this;
    }

    public VendorInformationObjectBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public VendorInformationObjectBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public VendorInformationObjectBuilder addAugmentation(Class<? extends Augmentation<VendorInformationObject>> augmentationType, Augmentation<VendorInformationObject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public VendorInformationObjectBuilder removeAugmentation(Class<? extends Augmentation<VendorInformationObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public VendorInformationObject build() {
        return new VendorInformationObjectImpl(this);
    }

    private static final class VendorInformationObjectImpl
    implements VendorInformationObject {
        private final EnterpriseNumber _enterpriseNumber;
        private final EnterpriseSpecificInformation _enterpriseSpecificInformation;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<VendorInformationObject> getImplementedInterface() {
            return VendorInformationObject.class;
        }

        private VendorInformationObjectImpl(VendorInformationObjectBuilder base) {
            this._enterpriseNumber = base.getEnterpriseNumber();
            this._enterpriseSpecificInformation = base.getEnterpriseSpecificInformation();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>>(base.augmentation);
                }
            }
        }

        @Override
        public EnterpriseNumber getEnterpriseNumber() {
            return this._enterpriseNumber;
        }

        @Override
        public EnterpriseSpecificInformation getEnterpriseSpecificInformation() {
            return this._enterpriseSpecificInformation;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        public <E extends Augmentation<VendorInformationObject>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._enterpriseNumber);
            result = 31 * result + Objects.hashCode(this._enterpriseSpecificInformation);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VendorInformationObject.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            VendorInformationObject other = (VendorInformationObject)obj;
            if (!Objects.equals(this._enterpriseNumber, other.getEnterpriseNumber())) {
                return false;
            }
            if (!Objects.equals(this._enterpriseSpecificInformation, other.getEnterpriseSpecificInformation())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VendorInformationObjectImpl otherImpl = (VendorInformationObjectImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<VendorInformationObject>>, Augmentation<VendorInformationObject>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "VendorInformationObject [";
            StringBuilder builder = new StringBuilder(name);
            if (this._enterpriseNumber != null) {
                builder.append("_enterpriseNumber=");
                builder.append(this._enterpriseNumber);
                builder.append(", ");
            }
            if (this._enterpriseSpecificInformation != null) {
                builder.append("_enterpriseSpecificInformation=");
                builder.append(this._enterpriseSpecificInformation);
                builder.append(", ");
            }
            if (this._ignore != null) {
                builder.append("_ignore=");
                builder.append(this._ignore);
                builder.append(", ");
            }
            if (this._processingRule != null) {
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

