/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.auto.bandwidth.extension;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.protocol.pcep.ietf.stateful07.Stateful07PCReportMessageParser;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.auto.bandwidth.rev181109.Bandwidth1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.auto.bandwidth.rev181109.Bandwidth1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.auto.bandwidth.rev181109.bandwidth.usage.object.BandwidthUsage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.auto.bandwidth.rev181109.bandwidth.usage.object.BandwidthUsageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcrpt.message.pcrpt.message.Reports;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcrpt.message.pcrpt.message.ReportsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcrpt.message.pcrpt.message.reports.Path;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev181109.pcrpt.message.pcrpt.message.reports.PathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.BandwidthBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class PcRptMessageCodec
extends Stateful07PCReportMessageParser {
    public PcRptMessageCodec(ObjectRegistry registry) {
        super(registry);
    }

    protected Reports getValidReports(List<Object> objects, List<Message> errors) {
        Path path;
        Object object;
        Optional find = Iterables.tryFind(objects, (Predicate)Predicates.instanceOf(BandwidthUsage.class));
        if (find.isPresent()) {
            object = (Object)find.get();
            objects.remove(object);
        } else {
            object = null;
        }
        Reports validReports = super.getValidReports(objects, errors);
        if (object != null && validReports != null && (path = validReports.getPath()) != null) {
            return new ReportsBuilder(validReports).setPath(new PathBuilder(path).setBandwidth(PcRptMessageCodec.setBandwidthUsage(path.getBandwidth(), (BandwidthUsage)object)).build()).build();
        }
        return validReports;
    }

    protected void serializeObject(Object object, ByteBuf buffer) {
        Bandwidth1 bw;
        super.serializeObject(object, buffer);
        if (object instanceof Bandwidth && (bw = (Bandwidth1)((Bandwidth)object).augmentation(Bandwidth1.class)) != null) {
            super.serializeObject((Object)new BandwidthUsageBuilder().setBwSample(bw.getBwSample()).build(), buffer);
        }
    }

    private static Bandwidth setBandwidthUsage(Bandwidth bandwidth, BandwidthUsage bwUsage) {
        BandwidthBuilder bandwidthBuilder = bandwidth != null ? new BandwidthBuilder(bandwidth) : new BandwidthBuilder();
        bandwidthBuilder.addAugmentation(Bandwidth1.class, (Augmentation)new Bandwidth1Builder().setBwSample(bwUsage.getBwSample()).build()).build();
        return bandwidthBuilder.build();
    }
}

