/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.auto.bandwidth.extension;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.auto.bandwidth.rev181109.bandwidth.usage.object.BandwidthUsage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.auto.bandwidth.rev181109.bandwidth.usage.object.BandwidthUsageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;

public final class BandwidthUsageObjectCodec
extends CommonObjectParser
implements ObjectSerializer {
    private static final int CLASS = 5;
    private static final int BW_LENGTH = 4;

    public BandwidthUsageObjectCodec(int type) {
        super(5, type);
    }

    public BandwidthUsage parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        if (bytes.readableBytes() % 4 != 0) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + bytes.readableBytes() + "; Expected multiple of 4.");
        }
        BandwidthUsageBuilder builder = new BandwidthUsageBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule());
        ArrayList<Bandwidth> bwSamples = new ArrayList<Bandwidth>(bytes.readableBytes() / 4);
        while (bytes.isReadable()) {
            bwSamples.add(new Bandwidth(ByteArray.readBytes((ByteBuf)bytes, (int)4)));
        }
        builder.setBwSample(bwSamples);
        return builder.build();
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof BandwidthUsage), (String)"Wrong instance of PCEPObject. Passed %s. Needed BandwidthUsage.", object.getClass());
        List bwSample = ((BandwidthUsage)object).getBwSample();
        ByteBuf body = Unpooled.buffer((int)(bwSample.size() * 4));
        for (Bandwidth bw : bwSample) {
            ByteBufWriteUtil.writeFloat32((Float32)bw, (ByteBuf)body);
        }
        ObjectUtil.formatSubobject((int)this.getObjectType(), (int)this.getObjectClass(), (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

