/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.auto.bandwidth.app.config.rev160707;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.auto.bandwidth.app.config.rev160707.PcepAutoBandwidthAppConfig;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;

public class PcepAutoBandwidthAppConfigBuilder {
    private Uint16 _bandwidthUsageObjectType;
    Map<Class<? extends Augmentation<PcepAutoBandwidthAppConfig>>, Augmentation<PcepAutoBandwidthAppConfig>> augmentation = Map.of();

    public PcepAutoBandwidthAppConfigBuilder() {
    }

    public PcepAutoBandwidthAppConfigBuilder(PcepAutoBandwidthAppConfig base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepAutoBandwidthAppConfig>>, Augmentation<PcepAutoBandwidthAppConfig>>(aug);
        }
        this._bandwidthUsageObjectType = base.getBandwidthUsageObjectType();
    }

    public Uint16 getBandwidthUsageObjectType() {
        return this._bandwidthUsageObjectType;
    }

    public <E$$ extends Augmentation<PcepAutoBandwidthAppConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    private static void checkBandwidthUsageObjectTypeRange(int value) {
        if (value >= 3 && value <= 15) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[3..15]]", (int)value);
    }

    public PcepAutoBandwidthAppConfigBuilder setBandwidthUsageObjectType(Uint16 value) {
        if (value != null) {
            PcepAutoBandwidthAppConfigBuilder.checkBandwidthUsageObjectTypeRange(value.intValue());
        }
        this._bandwidthUsageObjectType = value;
        return this;
    }

    public PcepAutoBandwidthAppConfigBuilder addAugmentation(Augmentation<PcepAutoBandwidthAppConfig> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepAutoBandwidthAppConfig>>, Augmentation<PcepAutoBandwidthAppConfig>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public PcepAutoBandwidthAppConfigBuilder removeAugmentation(Class<? extends Augmentation<PcepAutoBandwidthAppConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull PcepAutoBandwidthAppConfig build() {
        return new PcepAutoBandwidthAppConfigImpl(this);
    }

    private static final class PcepAutoBandwidthAppConfigImpl
    extends AbstractAugmentable<PcepAutoBandwidthAppConfig>
    implements PcepAutoBandwidthAppConfig {
        private final Uint16 _bandwidthUsageObjectType;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PcepAutoBandwidthAppConfigImpl(PcepAutoBandwidthAppConfigBuilder base) {
            super(base.augmentation);
            this._bandwidthUsageObjectType = base.getBandwidthUsageObjectType();
        }

        @Override
        public Uint16 getBandwidthUsageObjectType() {
            return this._bandwidthUsageObjectType;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = PcepAutoBandwidthAppConfig.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return PcepAutoBandwidthAppConfig.bindingEquals(this, obj);
        }

        public String toString() {
            return PcepAutoBandwidthAppConfig.bindingToString(this);
        }
    }
}

