/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.auto.bandwidth.extension;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.protocol.pcep.auto.bandwidth.extension.BandwidthUsageObjectCodec;
import org.opendaylight.protocol.pcep.auto.bandwidth.extension.PcRptMessageCodec;
import org.opendaylight.protocol.pcep.spi.MessageParser;
import org.opendaylight.protocol.pcep.spi.MessageSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.PCEPExtensionProviderActivator;
import org.opendaylight.protocol.pcep.spi.PCEPExtensionProviderContext;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.auto.bandwidth.rev181109.bandwidth.usage.object.BandwidthUsage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev200720.Pcrpt;
import org.opendaylight.yangtools.concepts.Registration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Singleton
@Component(immediate=true)
@Designate(ocd=Configuration.class)
public class AutoBandwidthActivator
implements PCEPExtensionProviderActivator {
    private static final byte DEFAULT_BANDWIDTH_OBJECT_TYPE = 5;
    private final int bandwidthObjectClass;

    @Inject
    public AutoBandwidthActivator() {
        this(5);
    }

    @Activate
    public AutoBandwidthActivator(Configuration config) {
        this(config.bandwidthObjectClass());
    }

    public AutoBandwidthActivator(byte bandwidthObjectType) {
        Preconditions.checkArgument((bandwidthObjectType >= 3 && bandwidthObjectType <= 15 ? 1 : 0) != 0, (String)"Object type %s is not in range [[3..15]]", (int)bandwidthObjectType);
        this.bandwidthObjectClass = bandwidthObjectType;
    }

    public List<Registration> start(PCEPExtensionProviderContext context) {
        BandwidthUsageObjectCodec bandwidthUsageObjectCodec = new BandwidthUsageObjectCodec(this.bandwidthObjectClass);
        PcRptMessageCodec pcRptMessageCodec = new PcRptMessageCodec(context.getObjectHandlerRegistry());
        return List.of(context.registerObjectParser((ObjectParser)bandwidthUsageObjectCodec), context.registerObjectSerializer(BandwidthUsage.class, (ObjectSerializer)bandwidthUsageObjectCodec), context.registerMessageParser(10, (MessageParser)pcRptMessageCodec), context.registerMessageSerializer(Pcrpt.class, (MessageSerializer)pcRptMessageCodec));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bandwithUsage", this.bandwidthObjectClass).toString();
    }

    @ObjectClassDefinition
    public static @interface Configuration {
        @AttributeDefinition(min="3", max="15", description="Object Class Value as per RFC5440")
        public byte bandwidthObjectClass() default 5;
    }
}

