/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.auto.bandwidth.extension;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.auto.bandwidth.rev171025.bandwidth.usage.object.BandwidthUsage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.auto.bandwidth.rev171025.bandwidth.usage.object.BandwidthUsageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;

public class BandwidthUsageObjectCodec
implements ObjectParser,
ObjectSerializer {
    static final int CLASS = 5;
    private static final int BW_LENGTH = 4;
    private final int type;

    public BandwidthUsageObjectCodec(int type) {
        this.type = type;
    }

    public BandwidthUsage parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        if (bytes.readableBytes() % 4 != 0) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + bytes.readableBytes() + "; Expected multiple of " + 4 + ".");
        }
        BandwidthUsageBuilder builder = new BandwidthUsageBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        ArrayList<Bandwidth> bwSamples = new ArrayList<Bandwidth>(bytes.readableBytes() / 4);
        while (bytes.isReadable()) {
            bwSamples.add(new Bandwidth(ByteArray.readBytes((ByteBuf)bytes, (int)4)));
        }
        builder.setBwSample(bwSamples);
        return builder.build();
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof BandwidthUsage), (String)"Wrong instance of PCEPObject. Passed %s. Needed BandwidthUsage.", object.getClass());
        List bwSample = ((BandwidthUsage)object).getBwSample();
        ByteBuf body = Unpooled.buffer((int)(bwSample.size() * 4));
        for (Bandwidth bw : bwSample) {
            ByteBufWriteUtil.writeFloat32((Float32)bw, (ByteBuf)body);
        }
        ObjectUtil.formatSubobject((int)this.getType(), (int)5, (Boolean)object.isProcessingRule(), (Boolean)object.isIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public int getType() {
        return this.type;
    }
}

