/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcc.id.req.object.PccIdReq;

public abstract class AbstractPccIdReqObjectParser
extends CommonObjectParser
implements ObjectSerializer {
    private static final int CLASS = 20;

    public AbstractPccIdReqObjectParser(int objectType) {
        super(20, objectType);
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof PccIdReq), (String)"Wrong instance of PCEPObject. Passed %s. Needed PccIdReqObject.", object.getClass());
        PccIdReq pccIdReq = (PccIdReq)object;
        if (pccIdReq.getIpAddress().getIpv4AddressNoZone() != null) {
            ByteBuf body = Unpooled.buffer((int)4);
            ByteBufWriteUtil.writeIpv4Address((Ipv4AddressNoZone)pccIdReq.getIpAddress().getIpv4AddressNoZone(), (ByteBuf)body);
            ObjectUtil.formatSubobject((int)this.getObjectType(), (int)this.getObjectClass(), (Boolean)object.isProcessingRule(), (Boolean)object.isIgnore(), (ByteBuf)body, (ByteBuf)buffer);
        } else if (pccIdReq.getIpAddress().getIpv6AddressNoZone() != null) {
            ByteBuf body = Unpooled.buffer((int)16);
            ByteBufWriteUtil.writeIpv6Address((Ipv6AddressNoZone)pccIdReq.getIpAddress().getIpv6AddressNoZone(), (ByteBuf)body);
            ObjectUtil.formatSubobject((int)this.getObjectType(), (int)this.getObjectClass(), (Boolean)object.isProcessingRule(), (Boolean)object.isIgnore(), (ByteBuf)body, (ByteBuf)buffer);
        }
    }
}

