/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.RROSubobjectRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.Subobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRROWithSubobjectsParser
extends CommonObjectParser
implements ObjectSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRROWithSubobjectsParser.class);
    private final RROSubobjectRegistry subobjReg;
    private static final int HEADER_LENGTH = 2;

    protected AbstractRROWithSubobjectsParser(RROSubobjectRegistry subobjReg, int objectClass, int objectType) {
        super(objectClass, objectType);
        this.subobjReg = Objects.requireNonNull(subobjReg);
    }

    protected List<Subobject> parseSubobjects(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        ArrayList<Subobject> subs = new ArrayList<Subobject>();
        while (buffer.isReadable()) {
            short type = buffer.readUnsignedByte();
            int length = buffer.readUnsignedByte() - 2;
            if (length > buffer.readableBytes()) {
                throw new PCEPDeserializerException("Wrong length specified. Passed: " + length + "; Expected: <= " + buffer.readableBytes());
            }
            LOG.debug("Attempt to parse subobject from bytes: {}", (Object)ByteBufUtil.hexDump((ByteBuf)buffer));
            Subobject sub = this.subobjReg.parseSubobject((int)type, buffer.readSlice(length));
            if (sub == null) {
                LOG.warn("Unknown subobject type: {}. Ignoring subobject.", (Object)type);
                continue;
            }
            LOG.debug("Subobject was parsed. {}", (Object)sub);
            subs.add(sub);
        }
        return subs;
    }

    protected final void serializeSubobject(List<Subobject> subobjects, ByteBuf buffer) {
        Preconditions.checkArgument((subobjects != null && !subobjects.isEmpty() ? 1 : 0) != 0, (Object)"RRO must contain at least one subobject.");
        for (Subobject subobject : subobjects) {
            this.subobjReg.serializeSubobject(subobject, buffer);
        }
    }
}

