/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.object.Overload;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.object.OverloadBuilder;

public class PCEPOverloadObjectParser
extends CommonObjectParser
implements ObjectSerializer {
    private static final int CLASS = 27;
    private static final int TYPE = 1;
    private static final int RESERVED = 1;
    private static final int FLAGS = 1;
    private static final int BODY_SIZE = 4;

    public PCEPOverloadObjectParser() {
        super(27, 1);
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof Overload), (String)"Wrong instance of PCEPObject. Passed %s. Needed OverloadObject.", object.getClass());
        Overload overload = (Overload)object;
        ByteBuf body = Unpooled.buffer((int)4);
        body.writeZero(2);
        ByteBufWriteUtil.writeUnsignedShort((Integer)overload.getDuration(), (ByteBuf)body);
        ObjectUtil.formatSubobject((int)1, (int)27, (Boolean)object.isProcessingRule(), (Boolean)object.isIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public Object parseObject(ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        OverloadBuilder builder = new OverloadBuilder();
        buffer.readBytes(2);
        builder.setDuration(Integer.valueOf(buffer.readUnsignedShort()));
        return builder.build();
    }
}

