/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTimeBuilder;

public class PCEPProcTimeObjectParser
extends CommonObjectParser
implements ObjectSerializer {
    private static final int CLASS = 26;
    private static final int TYPE = 1;
    private static final int RESERVED = 2;
    private static final int FLAGS = 16;
    private static final int COUNT_FIELDS = 5;
    private static final int BODY_SIZE = 38;
    private static final int E_FLAG_POSITION = 15;

    public PCEPProcTimeObjectParser() {
        super(26, 1);
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof ProcTime), (String)"Wrong instance of PCEPObject. Passed %s. Needed ProcTimeObject.", object.getClass());
        ProcTime procTime = (ProcTime)object;
        ByteBuf body = Unpooled.buffer((int)38);
        body.writeZero(2);
        BitArray flagBits = new BitArray(16);
        flagBits.set(15, procTime.isEstimated());
        flagBits.toByteBuf(body);
        ByteBufWriteUtil.writeUnsignedInt((Long)procTime.getCurrentProcTime(), (ByteBuf)body);
        ByteBufWriteUtil.writeUnsignedInt((Long)procTime.getMinProcTime(), (ByteBuf)body);
        ByteBufWriteUtil.writeUnsignedInt((Long)procTime.getMaxProcTime(), (ByteBuf)body);
        ByteBufWriteUtil.writeUnsignedInt((Long)procTime.getAverageProcTime(), (ByteBuf)body);
        ByteBufWriteUtil.writeUnsignedInt((Long)procTime.getVarianceProcTime(), (ByteBuf)body);
        ObjectUtil.formatSubobject((int)1, (int)26, (Boolean)object.isProcessingRule(), (Boolean)object.isIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public Object parseObject(ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        ProcTimeBuilder builder = new ProcTimeBuilder();
        buffer.skipBytes(2);
        BitArray flagBits = BitArray.valueOf((ByteBuf)buffer, (int)16);
        builder.setEstimated(Boolean.valueOf(flagBits.get(15)));
        builder.setCurrentProcTime(Long.valueOf(buffer.readUnsignedInt()));
        builder.setMinProcTime(Long.valueOf(buffer.readUnsignedInt()));
        builder.setMaxProcTime(Long.valueOf(buffer.readUnsignedInt()));
        builder.setAverageProcTime(Long.valueOf(buffer.readUnsignedInt()));
        builder.setVarianceProcTime(Long.valueOf(buffer.readUnsignedInt()));
        return builder.build();
    }
}

