/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object.end.points;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.Ipv6CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case.Ipv6;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case.Ipv6Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object.EndpointsObjBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PCEPEndPointsIpv6ObjectParser
extends CommonObjectParser {
    private static final int CLASS = 4;
    private static final int TYPE = 2;
    private static final Logger LOG = LoggerFactory.getLogger(PCEPEndPointsIpv6ObjectParser.class);

    public PCEPEndPointsIpv6ObjectParser() {
        super(4, 2);
    }

    public static void serializeObject(Boolean processing, Boolean ignore, Ipv6 ipv6, ByteBuf buffer) {
        ByteBuf body = Unpooled.buffer((int)32);
        Preconditions.checkArgument((ipv6.getSourceIpv6Address() != null ? 1 : 0) != 0, (java.lang.Object)"SourceIpv6Address is mandatory.");
        ByteBufWriteUtil.writeIpv6Address((Ipv6AddressNoZone)ipv6.getSourceIpv6Address(), (ByteBuf)body);
        Preconditions.checkArgument((ipv6.getDestinationIpv6Address() != null ? 1 : 0) != 0, (java.lang.Object)"DestinationIpv6Address is mandatory.");
        ByteBufWriteUtil.writeIpv6Address((Ipv6AddressNoZone)ipv6.getDestinationIpv6Address(), (ByteBuf)body);
        ObjectUtil.formatSubobject((int)2, (int)4, (Boolean)processing, (Boolean)ignore, (ByteBuf)body, (ByteBuf)buffer);
    }

    public Object parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        EndpointsObjBuilder builder = new EndpointsObjBuilder();
        if (!header.isProcessingRule().booleanValue()) {
            LOG.debug("Processed bit not set on Endpoints OBJECT, ignoring it.");
            return new UnknownObject(PCEPErrors.P_FLAG_NOT_SET, (Object)builder.build());
        }
        if (bytes.readableBytes() != 32) {
            throw new PCEPDeserializerException("Wrong length of array of bytes.");
        }
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        Ipv6Builder b = new Ipv6Builder();
        b.setSourceIpv6Address(Ipv6Util.noZoneAddressForByteBuf((ByteBuf)bytes));
        b.setDestinationIpv6Address(Ipv6Util.noZoneAddressForByteBuf((ByteBuf)bytes));
        builder.setAddressFamily((AddressFamily)new Ipv6CaseBuilder().setIpv6(b.build()).build());
        return builder.build();
    }
}

