/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.XROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.XROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.XROSubobjectUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ExcludeRouteSubobjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.UnnumberedCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.UnnumberedCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.unnumbered._case.Unnumbered;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.unnumbered._case.UnnumberedBuilder;

public class XROUnnumberedInterfaceSubobjectParser
implements XROSubobjectParser,
XROSubobjectSerializer {
    public static final int TYPE = 4;
    private static final int RESERVED = 1;
    private static final int CONTENT_LENGTH = 10;

    public Subobject parseSubobject(ByteBuf buffer, boolean mandatory) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        if (buffer.readableBytes() != 10) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: " + 10 + ".");
        }
        buffer.readerIndex(buffer.readerIndex() + 1);
        SubobjectBuilder builder = new SubobjectBuilder();
        builder.setMandatory(Boolean.valueOf(mandatory));
        builder.setAttribute(ExcludeRouteSubobjects.Attribute.forValue((int)buffer.readUnsignedByte()));
        UnnumberedBuilder ubuilder = new UnnumberedBuilder();
        ubuilder.setRouterId(Long.valueOf(buffer.readUnsignedInt()));
        ubuilder.setInterfaceId(Long.valueOf(buffer.readUnsignedInt()));
        builder.setSubobjectType((SubobjectType)new UnnumberedCaseBuilder().setUnnumbered(ubuilder.build()).build());
        return builder.build();
    }

    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(subobject.getSubobjectType() instanceof UnnumberedCase), (String)"Unknown subobject instance. Passed %s. Needed UnnumberedCase.", subobject.getSubobjectType().getClass());
        Unnumbered specObj = ((UnnumberedCase)subobject.getSubobjectType()).getUnnumbered();
        ByteBuf body = Unpooled.buffer((int)10);
        body.writeZero(1);
        ByteBufWriteUtil.writeUnsignedByte(subobject.getAttribute() != null ? Short.valueOf((short)subobject.getAttribute().getIntValue()) : null, (ByteBuf)body);
        Preconditions.checkArgument((specObj.getRouterId() != null ? 1 : 0) != 0, (Object)"RouterId is mandatory.");
        ByteBufWriteUtil.writeUnsignedInt((Long)specObj.getRouterId(), (ByteBuf)body);
        Preconditions.checkArgument((specObj.getInterfaceId() != null ? 1 : 0) != 0, (Object)"InterfaceId is mandatory.");
        ByteBufWriteUtil.writeUnsignedInt((Long)specObj.getInterfaceId(), (ByteBuf)body);
        XROSubobjectUtil.formatSubobject((int)4, (Boolean)subobject.isMandatory(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

