/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.list.tlv.OfList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.list.tlv.OfListBuilder;

public class OFListTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 4;
    private static final int OF_CODE_ELEMENT_LENGTH = 2;

    public OfList parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        if (buffer.readableBytes() % 2 != 0) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + ".");
        }
        ArrayList<OfId> ofCodes = new ArrayList<OfId>();
        while (buffer.isReadable()) {
            ofCodes.add(new OfId(Integer.valueOf(buffer.readUnsignedShort())));
        }
        return new OfListBuilder().setCodes(ofCodes).build();
    }

    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(tlv instanceof OfList), (Object)"OFListTlv is mandatory.");
        OfList oft = (OfList)tlv;
        ByteBuf body = Unpooled.buffer();
        List ofCodes = oft.getCodes();
        for (OfId id : ofCodes) {
            ByteBufWriteUtil.writeUnsignedShort((Integer)id.getValue(), (ByteBuf)body);
        }
        TlvUtil.formatTlv((int)4, (ByteBuf)body, (ByteBuf)buffer);
    }
}

