/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.duration.tlv.OverloadDuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.duration.tlv.OverloadDurationBuilder;

public class OverloadedDurationTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 2;

    public OverloadDuration parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        return new OverloadDurationBuilder().setDuration(Long.valueOf(buffer.readUnsignedInt())).build();
    }

    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(tlv instanceof OverloadDuration), (Object)"OverloadedTlv is mandatory.");
        ByteBuf body = Unpooled.buffer();
        ByteBufWriteUtil.writeUnsignedInt((Long)((OverloadDuration)tlv).getDuration(), (ByteBuf)body);
        TlvUtil.formatTlv((int)2, (ByteBuf)body, (ByteBuf)buffer);
    }
}

