/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.Gc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.GcBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.gc.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.gc.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;

public class PCEPGlobalConstraintsObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    private static final int CLASS = 24;
    private static final int TYPE = 1;

    public PCEPGlobalConstraintsObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg, 24, 1);
    }

    public Gc parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        GcBuilder builder = new GcBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        builder.setMaxHop(Short.valueOf(bytes.readUnsignedByte()));
        builder.setMaxUtilization(Short.valueOf(bytes.readUnsignedByte()));
        builder.setMinUtilization(Short.valueOf(bytes.readUnsignedByte()));
        builder.setOverBookingFactor(Short.valueOf(bytes.readUnsignedByte()));
        TlvsBuilder tlvsBuilder = new TlvsBuilder();
        this.parseTlvs(tlvsBuilder, bytes.slice());
        builder.setTlvs(tlvsBuilder.build());
        return builder.build();
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof Gc), (String)"Wrong instance of PCEPObject. Passed %s. Needed GcObject.", object.getClass());
        Gc specObj = (Gc)object;
        ByteBuf body = Unpooled.buffer();
        ByteBufWriteUtil.writeUnsignedByte((Short)specObj.getMaxHop(), (ByteBuf)body);
        ByteBufWriteUtil.writeUnsignedByte((Short)specObj.getMaxUtilization(), (ByteBuf)body);
        ByteBufWriteUtil.writeUnsignedByte((Short)specObj.getMinUtilization(), (ByteBuf)body);
        ByteBufWriteUtil.writeUnsignedByte((Short)specObj.getOverBookingFactor(), (ByteBuf)body);
        this.serializeTlvs(specObj.getTlvs(), body);
        ObjectUtil.formatSubobject((int)1, (int)24, (Boolean)object.isProcessingRule(), (Boolean)object.isIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs == null) {
            return;
        }
        this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
    }

    protected final void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }
}

