/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.CNotification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.CNotificationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.c.notification.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.notification.object.c.notification.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.duration.tlv.OverloadDuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;

public final class PCEPNotificationObjectParser
extends AbstractObjectWithTlvsParser<CNotificationBuilder> {
    private static final int CLASS = 12;
    private static final int TYPE = 1;
    private static final int NT_F_OFFSET = 2;

    public PCEPNotificationObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg, 12, 1);
    }

    public CNotification parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        CNotificationBuilder builder = new CNotificationBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        bytes.skipBytes(2);
        builder.setType(Short.valueOf(bytes.readUnsignedByte()));
        builder.setValue(Short.valueOf(bytes.readUnsignedByte()));
        this.parseTlvs(builder, bytes.slice());
        return builder.build();
    }

    public void addTlv(CNotificationBuilder builder, Tlv tlv) {
        if (tlv instanceof OverloadDuration && builder.getType() == 2 && builder.getValue() == 1) {
            builder.setTlvs(new TlvsBuilder().setOverloadDuration((OverloadDuration)tlv).build());
        }
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof CNotification), (String)"Wrong instance of PCEPObject. Passed %s. Needed CNotificationObject.", object.getClass());
        CNotification notObj = (CNotification)object;
        ByteBuf body = Unpooled.buffer();
        body.writeZero(2);
        Preconditions.checkArgument((notObj.getType() != null ? 1 : 0) != 0, (java.lang.Object)"Type is mandatory.");
        ByteBufWriteUtil.writeUnsignedByte((Short)notObj.getType(), (ByteBuf)body);
        Preconditions.checkArgument((notObj.getValue() != null ? 1 : 0) != 0, (java.lang.Object)"Value is mandatory.");
        ByteBufWriteUtil.writeUnsignedByte((Short)notObj.getValue(), (ByteBuf)body);
        this.serializeTlvs(notObj.getTlvs(), body);
        ObjectUtil.formatSubobject((int)1, (int)12, (Boolean)object.isProcessingRule(), (Boolean)object.isIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs == null) {
            return;
        }
        if (tlvs.getOverloadDuration() != null) {
            this.serializeTlv((Tlv)tlvs.getOverloadDuration(), body);
        }
        this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
    }

    protected final void addVendorInformationTlvs(CNotificationBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setTlvs(new TlvsBuilder(builder.getTlvs()).setVendorInformationTlv(tlvs).build());
        }
    }
}

