/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object.end.points;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.pcep.parser.object.end.points.PCEPEndPointsIpv4ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.end.points.PCEPEndPointsIpv6ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.end.points.PCEPP2MPEndPointsIpv4ObjectParser;
import org.opendaylight.protocol.pcep.parser.object.end.points.PCEPP2MPEndPointsIpv6ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.Ipv4Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.Ipv6Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.P2mpIpv4Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.P2mpIpv6Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv4._case.Ipv4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv6._case.Ipv6;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv4._case.P2mpIpv4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv6._case.P2mpIpv6;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object.EndpointsObj;

public final class PCEPEndPointsObjectSerializer
implements ObjectSerializer {
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof EndpointsObj), (String)"Wrong instance of PCEPObject. Passed %s. Needed EndpointsObject.", object.getClass());
        EndpointsObj ePObj = (EndpointsObj)object;
        AddressFamily afi = ePObj.getAddressFamily();
        Boolean processing = object.isProcessingRule();
        Boolean ignore = object.isIgnore();
        if (afi instanceof Ipv6Case) {
            Ipv6 ipv6 = ((Ipv6Case)afi).getIpv6();
            PCEPEndPointsIpv6ObjectParser.serializeObject(processing, ignore, ipv6, buffer);
        } else if (afi instanceof Ipv4Case) {
            Ipv4 ipv4 = ((Ipv4Case)afi).getIpv4();
            PCEPEndPointsIpv4ObjectParser.serializeObject(processing, ignore, ipv4, buffer);
        } else if (afi instanceof P2mpIpv4Case) {
            P2mpIpv4 ipv4 = ((P2mpIpv4Case)afi).getP2mpIpv4();
            PCEPP2MPEndPointsIpv4ObjectParser.serializeObject(processing, ignore, ipv4, buffer);
        } else if (afi instanceof P2mpIpv6Case) {
            P2mpIpv6 ipv6 = ((P2mpIpv6Case)afi).getP2mpIpv6();
            PCEPP2MPEndPointsIpv6ObjectParser.serializeObject(processing, ignore, ipv6, buffer);
        }
    }
}

