/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.EROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.EROSubobjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.UnnumberedCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.UnnumberedCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.unnumbered._case.Unnumbered;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.unnumbered._case.UnnumberedBuilder;

public class EROUnnumberedInterfaceSubobjectParser
implements EROSubobjectParser,
EROSubobjectSerializer {
    public static final int TYPE = 4;
    private static final int RESERVED = 2;
    private static final int CONTENT_LENGTH = 10;

    public Subobject parseSubobject(ByteBuf buffer, boolean loose) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        if (buffer.readableBytes() != 10) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: " + 10 + ".");
        }
        SubobjectBuilder builder = new SubobjectBuilder();
        builder.setLoose(Boolean.valueOf(loose));
        UnnumberedBuilder ubuilder = new UnnumberedBuilder();
        buffer.skipBytes(2);
        ubuilder.setRouterId(Long.valueOf(buffer.readUnsignedInt()));
        ubuilder.setInterfaceId(Long.valueOf(buffer.readUnsignedInt()));
        builder.setSubobjectType((SubobjectType)new UnnumberedCaseBuilder().setUnnumbered(ubuilder.build()).build());
        return builder.build();
    }

    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(subobject.getSubobjectType() instanceof UnnumberedCase), (String)"Unknown subobject instance. Passed %s. Needed UnnumberedCase.", subobject.getSubobjectType().getClass());
        Unnumbered specObj = ((UnnumberedCase)subobject.getSubobjectType()).getUnnumbered();
        ByteBuf body = Unpooled.buffer((int)10);
        body.writeZero(2);
        Preconditions.checkArgument((specObj.getRouterId() != null ? 1 : 0) != 0, (Object)"RouterId is mandatory.");
        ByteBufWriteUtil.writeUnsignedInt((Long)specObj.getRouterId(), (ByteBuf)body);
        Preconditions.checkArgument((specObj.getInterfaceId() != null ? 1 : 0) != 0, (Object)"InterfaceId is mandatory");
        ByteBufWriteUtil.writeUnsignedInt((Long)specObj.getInterfaceId(), (ByteBuf)body);
        EROSubobjectUtil.formatSubobject((int)4, (Boolean)subobject.isLoose(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

