/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.RROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.RROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.RROSubobjectUtil;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.UnnumberedCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.UnnumberedCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.unnumbered._case.Unnumbered;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.unnumbered._case.UnnumberedBuilder;

public class RROUnnumberedInterfaceSubobjectParser
implements RROSubobjectParser,
RROSubobjectSerializer {
    public static final int TYPE = 4;
    private static final int FLAGS_SIZE = 8;
    private static final int RESERVED = 1;
    private static final int CONTENT_LENGTH = 10;
    private static final int LPA_F_OFFSET = 7;
    private static final int LPIU_F_OFFSET = 6;

    public Subobject parseSubobject(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        if (buffer.readableBytes() != 10) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: " + 10 + ".");
        }
        SubobjectBuilder builder = new SubobjectBuilder();
        BitArray flags = BitArray.valueOf((ByteBuf)buffer, (int)8);
        builder.setProtectionAvailable(Boolean.valueOf(flags.get(7)));
        builder.setProtectionInUse(Boolean.valueOf(flags.get(6)));
        UnnumberedBuilder ubuilder = new UnnumberedBuilder();
        buffer.skipBytes(1);
        ubuilder.setRouterId(Long.valueOf(buffer.readUnsignedInt()));
        ubuilder.setInterfaceId(Long.valueOf(buffer.readUnsignedInt()));
        builder.setSubobjectType((SubobjectType)new UnnumberedCaseBuilder().setUnnumbered(ubuilder.build()).build());
        return builder.build();
    }

    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(subobject.getSubobjectType() instanceof UnnumberedCase), (String)"Unknown subobject instance. Passed %s. Needed UnnumberedCase.", subobject.getSubobjectType().getClass());
        Unnumbered specObj = ((UnnumberedCase)subobject.getSubobjectType()).getUnnumbered();
        BitArray flags = new BitArray(8);
        flags.set(7, subobject.isProtectionAvailable());
        flags.set(6, subobject.isProtectionInUse());
        ByteBuf body = Unpooled.buffer((int)10);
        flags.toByteBuf(body);
        body.writeZero(1);
        Preconditions.checkArgument((specObj.getRouterId() != null ? 1 : 0) != 0, (Object)"RouterId is mandatory.");
        ByteBufWriteUtil.writeUnsignedInt((Long)specObj.getRouterId(), (ByteBuf)body);
        Preconditions.checkArgument((specObj.getInterfaceId() != null ? 1 : 0) != 0, (Object)"InterfaceId is mandatory.");
        ByteBufWriteUtil.writeUnsignedInt((Long)specObj.getInterfaceId(), (ByteBuf)body);
        RROSubobjectUtil.formatSubobject((int)4, (ByteBuf)body, (ByteBuf)buffer);
    }
}

